/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.micromigration.microstream.v5;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import one.microstream.storage.embedded.types.EmbeddedStorageManager;
import software.xdev.micromigration.MigrationManager;
import software.xdev.micromigration.microstream.v5.TunnelingEmbeddedStorageManager;
import software.xdev.micromigration.migrater.MicroMigrater;
import software.xdev.micromigration.version.MigrationVersion;
import software.xdev.micromigration.version.Versioned;

public class MigrationManagerV5
implements MigrationManager {
    private final Supplier<MigrationVersion> currentVersionGetter;
    private final Consumer<MigrationVersion> currentVersionSetter;
    private final Consumer<MigrationVersion> currentVersionStorer;
    private final MicroMigrater migrater;
    private final EmbeddedStorageManager storageManager;

    public MigrationManagerV5(Supplier<MigrationVersion> currentVersionGetter, Consumer<MigrationVersion> currentVersionSetter, Consumer<MigrationVersion> currentVersionStorer, MicroMigrater migrater, EmbeddedStorageManager storageManager) {
        Objects.requireNonNull(currentVersionGetter);
        Objects.requireNonNull(currentVersionSetter);
        Objects.requireNonNull(currentVersionStorer);
        Objects.requireNonNull(migrater);
        Objects.requireNonNull(storageManager);
        this.currentVersionGetter = currentVersionGetter;
        this.currentVersionSetter = currentVersionSetter;
        this.currentVersionStorer = currentVersionStorer;
        this.migrater = migrater;
        this.storageManager = storageManager;
    }

    public MigrationManagerV5(Versioned versionedObject, MicroMigrater migrater, EmbeddedStorageManager storageManager) {
        this(() -> versionedObject.getVersion(), version -> versionedObject.setVersion((MigrationVersion)version), version -> storageManager.store((Object)versionedObject), migrater, storageManager);
        Objects.requireNonNull(versionedObject);
    }

    @Override
    public void migrate(Object objectToMigrate) {
        MigrationVersion versionBeforeUpdate = this.currentVersionGetter.get();
        MigrationVersion versionAfterUpdate = this.migrater.migrateToNewest(versionBeforeUpdate, new TunnelingEmbeddedStorageManager(this.storageManager), objectToMigrate);
        if (!versionAfterUpdate.equals(versionBeforeUpdate)) {
            this.currentVersionSetter.accept(versionAfterUpdate);
            this.currentVersionStorer.accept(versionAfterUpdate);
        }
    }
}

