/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.micromigration.microstream.v5;

import java.util.Objects;
import one.microstream.storage.embedded.types.EmbeddedStorageManager;
import software.xdev.micromigration.microstream.v5.MigrationManagerV5;
import software.xdev.micromigration.microstream.v5.TunnelingEmbeddedStorageManager;
import software.xdev.micromigration.migrater.MicroMigrater;
import software.xdev.micromigration.version.MigrationVersion;
import software.xdev.micromigration.version.VersionedRoot;

public class MigrationEmbeddedStorageManager
extends TunnelingEmbeddedStorageManager {
    private final MicroMigrater migrater;
    private VersionedRoot versionRoot;

    public MigrationEmbeddedStorageManager(EmbeddedStorageManager nativeManager, MicroMigrater migrater) {
        super(nativeManager);
        Objects.requireNonNull(migrater);
        this.migrater = migrater;
    }

    @Override
    public MigrationEmbeddedStorageManager start() {
        this.nativeManager.start();
        if (this.nativeManager.root() instanceof VersionedRoot) {
            this.versionRoot = (VersionedRoot)this.nativeManager.root();
        } else {
            this.versionRoot = new VersionedRoot(this.nativeManager.root());
            this.nativeManager.setRoot((Object)this.versionRoot);
            this.nativeManager.storeRoot();
        }
        new MigrationManagerV5(this.versionRoot, this.migrater, this).migrate(this.versionRoot.getRoot());
        return this;
    }

    public MigrationVersion getCurrentVersion() {
        return this.versionRoot.getVersion();
    }

    @Override
    public Object root() {
        return this.versionRoot.getRoot();
    }

    @Override
    public Object setRoot(Object newRoot) {
        this.versionRoot.setRoot(newRoot);
        return newRoot;
    }

    @Override
    public long storeRoot() {
        return this.nativeManager.store((Object)this.versionRoot);
    }
}

