/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.time;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.StopWatch;
import software.xdev.time.HierarchicalStopWatchAutoClosable;

public class HierarchicalStopWatch {
    protected static final double NANOS_TO_MILLIS_FACTOR = 1000000.0;
    protected final String taskName;
    protected final boolean async;
    protected final boolean enabled;
    protected final StopWatch sw = new StopWatch();
    protected final List<HierarchicalStopWatch> nestedProfilers = Collections.synchronizedList(new ArrayList());

    public HierarchicalStopWatch(String taskName, boolean async, boolean enabled) {
        this.taskName = Objects.requireNonNull(taskName);
        this.async = async;
        this.enabled = enabled;
    }

    public HierarchicalStopWatch(String taskName, boolean async) {
        this(taskName, async, true);
    }

    public HierarchicalStopWatch(String taskName) {
        this(taskName, false);
    }

    protected String gettaskName() {
        return this.taskName;
    }

    public StopWatch getStopWatch() {
        return this.sw;
    }

    protected boolean isEnabled() {
        return this.enabled;
    }

    protected boolean isAsync() {
        return this.async;
    }

    protected boolean isNotAsync() {
        return !this.isAsync();
    }

    public void start() {
        if (!this.isEnabled()) {
            return;
        }
        this.sw.start();
    }

    public void stop() {
        if (!this.sw.isStopped()) {
            this.sw.stop();
        }
    }

    public void stopAll() {
        this.stop();
        for (HierarchicalStopWatch hsw : this.nestedProfilers) {
            hsw.stopAll();
        }
    }

    protected void addNested(HierarchicalStopWatch nested, boolean start) {
        if (!this.isEnabled()) {
            return;
        }
        this.nestedProfilers.add(nested);
        if (start) {
            nested.start();
        }
    }

    public HierarchicalStopWatch nested(String taskName, boolean async) {
        HierarchicalStopWatch nested = new HierarchicalStopWatch(taskName, async, this.isEnabled());
        this.addNested(nested, true);
        return nested;
    }

    public HierarchicalStopWatch nested(String taskName) {
        return this.nested(taskName, false);
    }

    public HierarchicalStopWatchAutoClosable nestedAC(String taskName, boolean async) {
        HierarchicalStopWatchAutoClosable nested = new HierarchicalStopWatchAutoClosable(taskName, async, this.isEnabled());
        this.addNested(nested, true);
        return nested;
    }

    public HierarchicalStopWatchAutoClosable nestedAC(String taskName) {
        return this.nestedAC(taskName, false);
    }

    public String getPrettyPrinted() {
        if (!this.isEnabled()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.lineSeparator());
        sb.append("-------------------------------");
        sb.append(System.lineSeparator());
        sb.append("Root    Parent  Task");
        sb.append(System.lineSeparator());
        sb.append("-------------------------------");
        sb.append(System.lineSeparator());
        long rootNanos = this.sw.getNanoTime();
        sb.append(new TaskEntry(rootNanos, rootNanos, 0, "-", this.gettaskName(), rootNanos).format());
        this.addNestedToStrBuilder(sb, rootNanos, 1);
        return sb.toString();
    }

    protected void addNestedToStrBuilder(StringBuilder sb, long rootNanos, int hierarchicalPosition) {
        long currentNanos;
        Map hierach = this.nestedProfilers.stream().collect(Collectors.groupingBy(HierarchicalStopWatch::gettaskName, LinkedHashMap::new, Collectors.toList()));
        long leftNanos = currentNanos = this.sw.getNanoTime();
        for (Map.Entry entry : hierach.entrySet()) {
            long groupMinNanos = ((List)entry.getValue()).stream().mapToLong(hsw -> hsw.getStopWatch().getNanoTime()).min().orElse(0L);
            long groupMaxNanos = ((List)entry.getValue()).stream().mapToLong(hsw -> hsw.getStopWatch().getNanoTime()).max().orElse(0L);
            int count = ((List)entry.getValue()).size();
            long groupNestedNanos = ((List)entry.getValue()).stream().mapToLong(hsw -> hsw.getStopWatch().getNanoTime()).sum();
            sb.append(new TaskEntry(rootNanos, currentNanos, hierarchicalPosition, "-", (String)entry.getKey(), count, groupMinNanos, groupMaxNanos, groupNestedNanos, ((List)entry.getValue()).stream().anyMatch(HierarchicalStopWatch::isAsync)).format());
            long groupNestedNanosNotAsync = ((List)entry.getValue()).stream().filter(HierarchicalStopWatch::isNotAsync).mapToLong(hsw -> hsw.getStopWatch().getNanoTime()).sum();
            leftNanos -= groupNestedNanosNotAsync;
            for (HierarchicalStopWatch hsw2 : (List)entry.getValue()) {
                hsw2.addNestedToStrBuilder(sb, rootNanos, hierarchicalPosition + 1);
            }
        }
        if (!hierach.isEmpty()) {
            sb.append(new TaskEntry(rootNanos, currentNanos, hierarchicalPosition, "?", "unspecified", leftNanos).format());
        }
    }

    public static HierarchicalStopWatch createStarted(String taskName) {
        HierarchicalStopWatch sw = new HierarchicalStopWatch(taskName);
        sw.start();
        return sw;
    }

    protected record TaskEntry(long rootNanos, long parentNanos, int hierarchicalPosition, String delimiter, String taskName, long count, long minNanos, long maxNanos, long currentNanos, boolean async) {
        public TaskEntry(long rootNanos, long parentNanos, int hierarchicalPosition, String delimiter, String taskName, long currentNanos) {
            this(rootNanos, parentNanos, hierarchicalPosition, delimiter, taskName, 0L, 0L, 0L, currentNanos, false);
        }

        public String format() {
            String percentFormat = "%6.2f%%";
            String asyncPercent = "  ASYNC";
            String multipleInfo = this.count() <= 1L ? "" : String.format("; %dx; min=%.0fms; max=%.0fms", this.count(), (double)this.minNanos() / 1000000.0, (double)this.maxNanos() / 1000000.0);
            double currentNanosDouble = this.currentNanos();
            return String.format("%s%s %s %s %s [%.0fms%s]%s", "  ".repeat(this.hierarchicalPosition()), this.async() ? "  ASYNC" : String.format("%6.2f%%", currentNanosDouble / (double)this.rootNanos() * 100.0), this.async() ? "  ASYNC" : String.format("%6.2f%%", currentNanosDouble / (double)this.parentNanos() * 100.0), this.delimiter(), this.taskName(), currentNanosDouble / 1000000.0, multipleInfo, System.lineSeparator());
        }
    }
}

