/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.far;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import software.xdev.far.ExecData;

public abstract class BaseProcessor<D extends ExecData> {
    protected D execData;
    protected boolean processDirectoryNames;
    protected boolean processFileContents;
    protected boolean processFilenames;

    protected BaseProcessor(D execData) {
        this(execData, true);
    }

    protected BaseProcessor(D execData, boolean autoDetectOverrides) {
        this.execData = execData;
        if (autoDetectOverrides) {
            this.autoDetectOverrides();
        }
        this.run();
    }

    protected Class<?> baseProcessorClassForAutoDetectOverrides() {
        return BaseProcessor.class;
    }

    protected void autoDetectOverrides() {
        Class<?> base = this.baseProcessorClassForAutoDetectOverrides();
        Class<?> currentClass = this.getClass();
        Predicate<String> isMethodOverridden = methodName -> Arrays.stream(currentClass.getDeclaredMethods()).filter(m -> methodName.equals(m.getName())).findFirst().map(Method::getDeclaringClass).map(d -> !base.equals(d)).orElse(false);
        this.processDirectoryNames = isMethodOverridden.test("handleDirectory");
        this.processFilenames = isMethodOverridden.test("handleFile");
        this.processFileContents = isMethodOverridden.test("handleFileContents");
    }

    protected void run() {
        ((ExecData)this.execData).getLogger().info((CharSequence)String.format("Looking up files inside basedir='%s' with file masks [%s]", ((ExecData)this.execData).getBaseDirPath().toString(), String.join((CharSequence)", ", ((ExecData)this.execData).getFileMasks())));
        File[] baseDirFiles = new File(((ExecData)this.execData).getBaseDirPath().toUri()).listFiles();
        if (baseDirFiles == null) {
            throw new UncheckedIOException(new IOException(String.format("Unable to list file(s) in baseDir='%s'", ((ExecData)this.execData).getBaseDirPath())));
        }
        ArrayList<File> filesToProcess = new ArrayList<File>(Arrays.asList(baseDirFiles));
        ListIterator<File> iterator = filesToProcess.listIterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            iterator.remove();
            if (file.isDirectory()) {
                iterator = this.processDirectory(iterator, file);
            }
            if (!file.isFile()) continue;
            this.processFile(file);
        }
    }

    protected ListIterator<File> processDirectory(ListIterator<File> iterator, File file) {
        File workFile = file;
        if (this.processDirectoryNames && !this.shouldExcludeFile(workFile)) {
            workFile = this.handleDirectory(workFile);
        }
        if (((ExecData)this.execData).isRecursive()) {
            File[] filesToAdd = workFile.listFiles();
            assert (filesToAdd != null);
            for (File f : filesToAdd) {
                iterator.add(f);
                iterator.previous();
            }
        }
        return iterator;
    }

    protected boolean shouldExcludeFile(File file) {
        return ((ExecData)this.execData).getExclusions().stream().anyMatch(p -> p.matcher(file.getName()).find());
    }

    protected File handleDirectory(File file) {
        return file;
    }

    protected void processFile(File file) {
        if (this.shouldExcludeFile(file) || !this.shouldProcessFile(file)) {
            return;
        }
        if (this.processFileContents) {
            this.handleFileContents(file);
        }
        if (this.processFilenames) {
            this.handleFile(file);
        }
    }

    protected boolean shouldProcessFile(File file) {
        if (((ExecData)this.execData).getFileMasks().isEmpty()) {
            return true;
        }
        return ((ExecData)this.execData).getFileMasks().stream().anyMatch(fileMask -> file.getName().endsWith((String)fileMask));
    }

    protected File handleFile(File file) {
        return file;
    }

    protected File renameFileDefault(File file) {
        String newName;
        String oldName = file.getName();
        Matcher matcher = ((ExecData)this.execData).getFindRegex().matcher(oldName);
        String string = newName = ((ExecData)this.execData).isReplaceAll() ? matcher.replaceAll(((ExecData)this.execData).getReplaceValue()) : matcher.replaceFirst(((ExecData)this.execData).getReplaceValue());
        if (!newName.equals(oldName)) {
            Path filePath = file.toPath();
            Path parentDir = filePath.getParent();
            Path targetPath = Paths.get(parentDir.toString(), newName);
            ((ExecData)this.execData).getLogger().info((CharSequence)String.format("Renaming %s to %s", oldName, newName));
            try {
                return new File(Files.move(filePath, targetPath, new CopyOption[0]).toUri());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return file;
    }

    protected void handleFileContents(File file) {
    }
}

