/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.far;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import software.xdev.far.ExecData;

public abstract class BaseMojo<D extends ExecData>
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="baseDir", defaultValue="${basedir}")
    protected String baseDir;
    @Parameter(property="recursive", defaultValue="false")
    protected boolean recursive;
    @Parameter(property="findRegex", required=true)
    protected String findRegex;
    @Parameter(property="replaceValue")
    protected String replaceValue;
    @Parameter(property="fileMask")
    protected String fileMask;
    @Parameter(property="exclusions")
    protected String exclusions;
    @Parameter(property="skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="replaceAll", defaultValue="true")
    protected boolean replaceAll = true;
    protected final Consumer<D> executeInternal;

    protected BaseMojo(Consumer<D> executeInternal) {
        this.executeInternal = Objects.requireNonNull(executeInternal);
    }

    public void execute() {
        if (this.skip) {
            this.getLog().warn((CharSequence)"Skipping execution");
            return;
        }
        this.executeInternal.accept(this.enrichData(this.createDefaultData()));
    }

    protected ExecData createDefaultData() {
        Path baseDirPath = Paths.get(this.baseDir, new String[0]);
        return new ExecData(this.getLog(), baseDirPath.isAbsolute() ? baseDirPath : Paths.get(this.project.getBasedir().getAbsolutePath(), this.baseDir), this.recursive, this.compileFindRegex(), Optional.ofNullable(this.replaceValue).orElse(""), Optional.ofNullable(this.fileMask).map(s -> List.of(s.split(","))).orElseGet(List::of), Optional.ofNullable(this.exclusions).map(Pattern::compile).map(List::of).orElseGet(List::of), this.replaceAll);
    }

    protected Pattern compileFindRegex() {
        return Pattern.compile(this.findRegex);
    }

    protected abstract D enrichData(ExecData var1);

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setFindRegex(String findRegex) {
        this.findRegex = findRegex;
    }

    public void setReplaceValue(String replaceValue) {
        this.replaceValue = replaceValue;
    }

    public void setFileMask(String fileMask) {
        this.fileMask = fileMask;
    }

    public void setExclusions(String exclusions) {
        this.exclusions = exclusions;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setReplaceAll(boolean replaceAll) {
        this.replaceAll = replaceAll;
    }
}

