/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.far.filecontents;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import software.xdev.far.BaseProcessor;
import software.xdev.far.filecontents.FileContentsExecData;

public class FileContentsProcessor
extends BaseProcessor<FileContentsExecData> {
    public FileContentsProcessor(FileContentsExecData execData) {
        super(execData);
    }

    @Override
    protected void handleFileContents(File file) {
        try {
            Path tempFile;
            block41: {
                tempFile = null;
                if (((FileContentsExecData)this.execData).isReplaceLineBased()) {
                    tempFile = this.createTempFile(file);
                    try (FileInputStream fis = new FileInputStream(file);
                         InputStreamReader isr = new InputStreamReader((InputStream)fis, ((FileContentsExecData)this.execData).getCharset());
                         BufferedReader fileReader = new BufferedReader(isr);
                         FileOutputStream fos = new FileOutputStream(tempFile.toFile());
                         OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, ((FileContentsExecData)this.execData).getCharset());
                         BufferedWriter fileWriter = new BufferedWriter(osr);){
                        boolean alreadyReplaced = false;
                        String line = fileReader.readLine();
                        while (line != null) {
                            String lineToWrite = line;
                            Matcher matcher = ((FileContentsExecData)this.execData).getFindRegex().matcher(line);
                            if (matcher.find()) {
                                if (((FileContentsExecData)this.execData).isReplaceAll()) {
                                    lineToWrite = matcher.replaceAll(((FileContentsExecData)this.execData).getReplaceValue());
                                } else if (!alreadyReplaced) {
                                    lineToWrite = matcher.replaceFirst(((FileContentsExecData)this.execData).getReplaceValue());
                                    alreadyReplaced = true;
                                }
                            }
                            fileWriter.write(lineToWrite + System.lineSeparator());
                            line = fileReader.readLine();
                        }
                        break block41;
                    }
                }
                String contents = Files.readString(file.toPath(), ((FileContentsExecData)this.execData).getCharset());
                Matcher matcher = ((FileContentsExecData)this.execData).getFindRegex().matcher(contents);
                if (matcher.find()) {
                    tempFile = this.createTempFile(file);
                    Files.writeString(tempFile, (CharSequence)(((FileContentsExecData)this.execData).isReplaceAll() ? matcher.replaceAll(((FileContentsExecData)this.execData).getReplaceValue()) : matcher.replaceFirst(((FileContentsExecData)this.execData).getReplaceValue())), new OpenOption[0]);
                }
            }
            if (tempFile != null) {
                Files.delete(file.toPath());
                if (!tempFile.toFile().renameTo(file)) {
                    throw new IOException("Failed to rename temp file at: " + tempFile + " to " + file.getPath());
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected Path createTempFile(File original) throws IOException {
        return Files.createTempFile(original.getParentFile().toPath(), "tmp", "tmp", new FileAttribute[0]);
    }
}

