/*
 * Copyright © 2024 XDEV Software (https://xdev.software)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package software.xdev.bzst.dip.client.xmldocument.model;

import java.util.ArrayList;
import java.util.List;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for OtherRPO_Type complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="OtherRPO_Type"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="ResCountryCode" type="{urn:oecd:ties:isodpitypes:v1}CountryCode_Type" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element name="TIN" type="{urn:oecd:ties:dpi:v1}TIN_Type" maxOccurs="unbounded"/&gt;
 *         &lt;element name="Name" type="{urn:oecd:ties:dpi:v1}NameOrganisation_Type"/&gt;
 *         &lt;element name="Address" type="{urn:oecd:ties:dpi:v1}Address_Type"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OtherRPO_Type", namespace = "urn:oecd:ties:dpi:v1", propOrder = {
	"resCountryCode",
	"tin",
	"name",
	"address"
})
@XmlSeeAlso({
	CorrectableOtherRPOType.class
})
public class OtherRPOType
{
	
	@XmlElement(name = "ResCountryCode", namespace = "urn:oecd:ties:dpi:v1")
	@XmlSchemaType(name = "string")
	protected List<CountryCodeType> resCountryCode;
	@XmlElement(name = "TIN", namespace = "urn:oecd:ties:dpi:v1", required = true)
	protected List<TINType> tin;
	@XmlElement(name = "Name", namespace = "urn:oecd:ties:dpi:v1", required = true)
	protected NameOrganisationType name;
	@XmlElement(name = "Address", namespace = "urn:oecd:ties:dpi:v1", required = true)
	protected AddressType address;
	
	/**
	 * Gets the value of the resCountryCode property.
	 *
	 * <p>
	 * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you
	 * make to
	 * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
	 * <CODE>set</CODE> method for the resCountryCode property.
	 *
	 * <p>
	 * For example, to add a new item, do as follows:
	 * <pre>
	 *    getResCountryCode().add(newItem);
	 * </pre>
	 *
	 *
	 * <p>
	 * Objects of the following type(s) are allowed in the list {@link CountryCodeType }
	 */
	public List<CountryCodeType> getResCountryCode()
	{
		if(this.resCountryCode == null)
		{
			this.resCountryCode = new ArrayList<>();
		}
		return this.resCountryCode;
	}
	
	/**
	 * Gets the value of the tin property.
	 *
	 * <p>
	 * This accessor method returns a reference to the live list, not a snapshot. Therefore any modification you
	 * make to
	 * the returned list will be present inside the Jakarta XML Binding object. This is why there is not a
	 * <CODE>set</CODE> method for the tin property.
	 *
	 * <p>
	 * For example, to add a new item, do as follows:
	 * <pre>
	 *    getTIN().add(newItem);
	 * </pre>
	 *
	 *
	 * <p>
	 * Objects of the following type(s) are allowed in the list {@link TINType }
	 */
	public List<TINType> getTIN()
	{
		if(this.tin == null)
		{
			this.tin = new ArrayList<>();
		}
		return this.tin;
	}
	
	/**
	 * Gets the value of the name property.
	 *
	 * @return possible object is {@link NameOrganisationType }
	 */
	public NameOrganisationType getName()
	{
		return this.name;
	}
	
	/**
	 * Sets the value of the name property.
	 *
	 * @param value allowed object is {@link NameOrganisationType }
	 */
	public void setName(final NameOrganisationType value)
	{
		this.name = value;
	}
	
	/**
	 * Gets the value of the address property.
	 *
	 * @return possible object is {@link AddressType }
	 */
	public AddressType getAddress()
	{
		return this.address;
	}
	
	/**
	 * Sets the value of the address property.
	 *
	 * @param value allowed object is {@link AddressType }
	 */
	public void setAddress(final AddressType value)
	{
		this.address = value;
	}
}
