/*
 * Copyright © 2024 XDEV Software (https://xdev.software)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package software.xdev.bzst.dip.client.model.message;

import software.xdev.bzst.dip.client.xmldocument.model.CountryCodeType;


@SuppressWarnings("checkstyle:MethodLength")
public enum BzstDipCountryCode
{
	/**
	 * AFGHANISTAN
	 */
	AF,
	
	/**
	 * ALAND ISLANDS
	 */
	AX,
	
	/**
	 * ALBANIA
	 */
	AL,
	
	/**
	 * ALGERIA
	 */
	DZ,
	
	/**
	 * AMERICAN SAMOA
	 */
	AS,
	
	/**
	 * ANDORRA
	 */
	AD,
	
	/**
	 * ANGOLA
	 */
	AO,
	
	/**
	 * ANGUILLA
	 */
	AI,
	
	/**
	 * ANTARCTICA
	 */
	AQ,
	
	/**
	 * ANTIGUA AND BARBUDA
	 */
	AG,
	
	/**
	 * ARGENTINA
	 */
	AR,
	
	/**
	 * ARMENIA
	 */
	AM,
	
	/**
	 * ARUBA
	 */
	AW,
	
	/**
	 * AUSTRALIA
	 */
	AU,
	
	/**
	 * AUSTRIA
	 */
	AT,
	
	/**
	 * AZERBAIJAN
	 */
	AZ,
	
	/**
	 * BAHAMAS
	 */
	BS,
	
	/**
	 * BAHRAIN
	 */
	BH,
	
	/**
	 * BANGLADESH
	 */
	BD,
	
	/**
	 * BARBADOS
	 */
	BB,
	
	/**
	 * BELARUS
	 */
	BY,
	
	/**
	 * BELGIUM
	 */
	BE,
	
	/**
	 * BELIZE
	 */
	BZ,
	
	/**
	 * BENIN
	 */
	BJ,
	
	/**
	 * BERMUDA
	 */
	BM,
	
	/**
	 * BHUTAN
	 */
	BT,
	
	/**
	 * BOLIVIA, PLURINATIONAL STATE OF
	 */
	BO,
	
	/**
	 * BONAIRE, SINT EUSTATIUS AND SABA
	 */
	BQ,
	
	/**
	 * BOSNIA AND HERZEGOVINA
	 */
	BA,
	
	/**
	 * BOTSWANA
	 */
	BW,
	
	/**
	 * BOUVET ISLAND
	 */
	BV,
	
	/**
	 * BRAZIL
	 */
	BR,
	
	/**
	 * BRITISH INDIAN OCEAN TERRITORY
	 */
	IO,
	
	/**
	 * BRUNEI DARUSSALAM
	 */
	BN,
	
	/**
	 * BULGARIA
	 */
	BG,
	
	/**
	 * BURKINA FASO
	 */
	BF,
	
	/**
	 * BURUNDI
	 */
	BI,
	
	/**
	 * CAMBODIA
	 */
	KH,
	
	/**
	 * CAMEROON
	 */
	CM,
	
	/**
	 * CANADA
	 */
	CA,
	
	/**
	 * CABO VERDE
	 */
	CV,
	
	/**
	 * CAYMAN ISLANDS
	 */
	KY,
	
	/**
	 * CENTRAL AFRICAN REPUBLIC
	 */
	CF,
	
	/**
	 * CHAD
	 */
	TD,
	
	/**
	 * CHILE
	 */
	CL,
	
	/**
	 * CHINA
	 */
	CN,
	
	/**
	 * CHRISTMAS ISLAND
	 */
	CX,
	
	/**
	 * COCOS (KEELING) ISLANDS
	 */
	CC,
	
	/**
	 * COLOMBIA
	 */
	CO,
	
	/**
	 * COMOROS
	 */
	KM,
	
	/**
	 * CONGO
	 */
	CG,
	
	/**
	 * CONGO, THE DEMOCRATIC REPUBLIC OF THE
	 */
	CD,
	
	/**
	 * COOK ISLANDS
	 */
	CK,
	
	/**
	 * COSTA RICA
	 */
	CR,
	
	/**
	 * COTE D'IVOIRE
	 */
	CI,
	
	/**
	 * CROATIA
	 */
	HR,
	
	/**
	 * CUBA
	 */
	CU,
	
	/**
	 * CURACAO
	 */
	CW,
	
	/**
	 * CYPRUS
	 */
	CY,
	
	/**
	 * CZECHIA
	 */
	CZ,
	
	/**
	 * DENMARK
	 */
	DK,
	
	/**
	 * DJIBOUTI
	 */
	DJ,
	
	/**
	 * DOMINICA
	 */
	DM,
	
	/**
	 * DOMINICAN REPUBLIC
	 */
	DO,
	
	/**
	 * ECUADOR
	 */
	EC,
	
	/**
	 * EGYPT
	 */
	EG,
	
	/**
	 * EL SALVADOR
	 */
	SV,
	
	/**
	 * EQUATORIAL GUINEA
	 */
	GQ,
	
	/**
	 * ERITREA
	 */
	ER,
	
	/**
	 * ESTONIA
	 */
	EE,
	
	/**
	 * ETHIOPIA
	 */
	ET,
	
	/**
	 * FALKLAND ISLANDS (MALVINAS)
	 */
	FK,
	
	/**
	 * FAROE ISLANDS
	 */
	FO,
	
	/**
	 * FIJI
	 */
	FJ,
	
	/**
	 * FINLAND
	 */
	FI,
	
	/**
	 * FRANCE
	 */
	FR,
	
	/**
	 * FRENCH GUIANA
	 */
	GF,
	
	/**
	 * FRENCH POLYNESIA
	 */
	PF,
	
	/**
	 * FRENCH SOUTHERN TERRITORIES
	 */
	TF,
	
	/**
	 * GABON
	 */
	GA,
	
	/**
	 * GAMBIA
	 */
	GM,
	
	/**
	 * GEORGIA
	 */
	GE,
	
	/**
	 * GERMANY
	 */
	DE,
	
	/**
	 * GHANA
	 */
	GH,
	
	/**
	 * GIBRALTAR
	 */
	GI,
	
	/**
	 * GREECE
	 */
	GR,
	
	/**
	 * GREENLAND
	 */
	GL,
	
	/**
	 * GRENADA
	 */
	GD,
	
	/**
	 * GUADELOUPE
	 */
	GP,
	
	/**
	 * GUAM
	 */
	GU,
	
	/**
	 * GUATEMALA
	 */
	GT,
	
	/**
	 * GUERNSEY
	 */
	GG,
	
	/**
	 * GUINEA
	 */
	GN,
	
	/**
	 * GUINEA-BISSAU
	 */
	GW,
	
	/**
	 * GUYANA
	 */
	GY,
	
	/**
	 * HAITI
	 */
	HT,
	
	/**
	 * HEARD ISLAND AND MCDONALD ISLANDS
	 */
	HM,
	
	/**
	 * HOLY SEE (VATICAN CITY STATE)
	 */
	VA,
	
	/**
	 * HONDURAS
	 */
	HN,
	
	/**
	 * HONG KONG
	 */
	HK,
	
	/**
	 * HUNGARY
	 */
	HU,
	
	/**
	 * ICELAND
	 */
	IS,
	
	/**
	 * INDIA
	 */
	IN,
	
	/**
	 * INDONESIA
	 */
	ID,
	
	/**
	 * IRAN, ISLAMIC REPUBLIC OF
	 */
	IR,
	
	/**
	 * IRAQ
	 */
	IQ,
	
	/**
	 * IRELAND
	 */
	IE,
	
	/**
	 * ISLE OF MAN
	 */
	IM,
	
	/**
	 * ISRAEL
	 */
	IL,
	
	/**
	 * ITALY
	 */
	IT,
	
	/**
	 * JAMAICA
	 */
	JM,
	
	/**
	 * JAPAN
	 */
	JP,
	
	/**
	 * JERSEY
	 */
	JE,
	
	/**
	 * JORDAN
	 */
	JO,
	
	/**
	 * KAZAKHSTAN
	 */
	KZ,
	
	/**
	 * KENYA
	 */
	KE,
	
	/**
	 * KIRIBATI
	 */
	KI,
	
	/**
	 * KOREA, DEMOCRATIC PEOPLE'S REPUBLIC OF
	 */
	KP,
	
	/**
	 * KOREA, REPUBLIC OF
	 */
	KR,
	
	/**
	 * KUWAIT
	 */
	KW,
	
	/**
	 * KYRGYZSTAN
	 */
	KG,
	
	/**
	 * LAO PEOPLE'S DEMOCRATIC REPUBLIC
	 */
	LA,
	
	/**
	 * LATVIA
	 */
	LV,
	
	/**
	 * LEBANON
	 */
	LB,
	
	/**
	 * LESOTHO
	 */
	LS,
	
	/**
	 * LIBERIA
	 */
	LR,
	
	/**
	 * LIBYA
	 */
	LY,
	
	/**
	 * LIECHTENSTEIN
	 */
	LI,
	
	/**
	 * LITHUANIA
	 */
	LT,
	
	/**
	 * LUXEMBOURG
	 */
	LU,
	
	/**
	 * MACAO
	 */
	MO,
	
	/**
	 * NORTH MACEDONIA
	 */
	MK,
	
	/**
	 * MADAGASCAR
	 */
	MG,
	
	/**
	 * MALAWI
	 */
	MW,
	
	/**
	 * MALAYSIA
	 */
	MY,
	
	/**
	 * MALDIVES
	 */
	MV,
	
	/**
	 * MALI
	 */
	ML,
	
	/**
	 * MALTA
	 */
	MT,
	
	/**
	 * MARSHALL ISLANDS
	 */
	MH,
	
	/**
	 * MARTINIQUE
	 */
	MQ,
	
	/**
	 * MAURITANIA
	 */
	MR,
	
	/**
	 * MAURITIUS
	 */
	MU,
	
	/**
	 * MAYOTTE
	 */
	YT,
	
	/**
	 * MEXICO
	 */
	MX,
	
	/**
	 * MICRONESIA, FEDERATED STATES OF
	 */
	FM,
	
	/**
	 * MOLDOVA, REPUBLIC OF
	 */
	MD,
	
	/**
	 * MONACO
	 */
	MC,
	
	/**
	 * MONGOLIA
	 */
	MN,
	
	/**
	 * MONTENEGRO
	 */
	ME,
	
	/**
	 * MONTSERRAT
	 */
	MS,
	
	/**
	 * MOROCCO
	 */
	MA,
	
	/**
	 * MOZAMBIQUE
	 */
	MZ,
	
	/**
	 * MYANMAR
	 */
	MM,
	
	/**
	 * NAMIBIA
	 */
	NA,
	
	/**
	 * NAURU
	 */
	NR,
	
	/**
	 * NEPAL
	 */
	NP,
	
	/**
	 * NETHERLANDS
	 */
	NL,
	
	/**
	 * NEW CALEDONIA
	 */
	NC,
	
	/**
	 * NEW ZEALAND
	 */
	NZ,
	
	/**
	 * NICARAGUA
	 */
	NI,
	
	/**
	 * NIGER
	 */
	NE,
	
	/**
	 * NIGERIA
	 */
	NG,
	
	/**
	 * NIUE
	 */
	NU,
	
	/**
	 * NORFOLK ISLAND
	 */
	NF,
	
	/**
	 * NORTHERN MARIANA ISLANDS
	 */
	MP,
	
	/**
	 * NORWAY
	 */
	NO,
	
	/**
	 * OMAN
	 */
	OM,
	
	/**
	 * PAKISTAN
	 */
	PK,
	
	/**
	 * PALAU
	 */
	PW,
	
	/**
	 * PALESTINE, STATE OF
	 */
	PS,
	
	/**
	 * PANAMA
	 */
	PA,
	
	/**
	 * PAPUA NEW GUINEA
	 */
	PG,
	
	/**
	 * PARAGUAY
	 */
	PY,
	
	/**
	 * PERU
	 */
	PE,
	
	/**
	 * PHILIPPINES
	 */
	PH,
	
	/**
	 * PITCAIRN
	 */
	PN,
	
	/**
	 * POLAND
	 */
	PL,
	
	/**
	 * PORTUGAL
	 */
	PT,
	
	/**
	 * PUERTO RICO
	 */
	PR,
	
	/**
	 * QATAR
	 */
	QA,
	
	/**
	 * REUNION
	 */
	RE,
	
	/**
	 * ROMANIA
	 */
	RO,
	
	/**
	 * RUSSIAN FEDERATION
	 */
	RU,
	
	/**
	 * RWANDA
	 */
	RW,
	
	/**
	 * SAINT BARTHELEMY
	 */
	BL,
	
	/**
	 * SAINT HELENA, ASCENSION AND TRISTAN DA CUNHA
	 */
	SH,
	
	/**
	 * SAINT KITTS AND NEVIS
	 */
	KN,
	
	/**
	 * SAINT LUCIA
	 */
	LC,
	
	/**
	 * SAINT MARTIN (FRENCH PART)
	 */
	MF,
	
	/**
	 * SAINT PIERRE AND MIQUELON
	 */
	PM,
	
	/**
	 * SAINT VINCENT AND THE GRENADINES
	 */
	VC,
	
	/**
	 * SAMOA
	 */
	WS,
	
	/**
	 * SAN MARINO
	 */
	SM,
	
	/**
	 * SAO TOME AND PRINCIPE
	 */
	ST,
	
	/**
	 * SAUDI ARABIA
	 */
	SA,
	
	/**
	 * SENEGAL
	 */
	SN,
	
	/**
	 * SERBIA
	 */
	RS,
	
	/**
	 * SEYCHELLES
	 */
	SC,
	
	/**
	 * SIERRA LEONE
	 */
	SL,
	
	/**
	 * SINGAPORE
	 */
	SG,
	
	/**
	 * SINT MAARTEN (DUTCH PART)
	 */
	SX,
	
	/**
	 * SLOVAKIA
	 */
	SK,
	
	/**
	 * SLOVENIA
	 */
	SI,
	
	/**
	 * SOLOMON ISLANDS
	 */
	SB,
	
	/**
	 * SOMALIA
	 */
	SO,
	
	/**
	 * SOUTH AFRICA
	 */
	ZA,
	
	/**
	 * SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS
	 */
	GS,
	
	/**
	 * SOUTH SUDAN
	 */
	SS,
	
	/**
	 * SPAIN
	 */
	ES,
	
	/**
	 * SRI LANKA
	 */
	LK,
	
	/**
	 * SUDAN
	 */
	SD,
	
	/**
	 * SURINAME
	 */
	SR,
	
	/**
	 * SVALBARD AND JAN MAYEN
	 */
	SJ,
	
	/**
	 * ESWATINI
	 */
	SZ,
	
	/**
	 * SWEDEN
	 */
	SE,
	
	/**
	 * SWITZERLAND
	 */
	CH,
	
	/**
	 * SYRIAN ARAB REPUBLIC
	 */
	SY,
	
	/**
	 * TAIWAN, PROVINCE OF CHINA
	 */
	TW,
	
	/**
	 * TAJIKISTAN
	 */
	TJ,
	
	/**
	 * TANZANIA, UNITED REPUBLIC OF
	 */
	TZ,
	
	/**
	 * THAILAND
	 */
	TH,
	
	/**
	 * TIMOR-LESTE
	 */
	TL,
	
	/**
	 * TOGO
	 */
	TG,
	
	/**
	 * TOKELAU
	 */
	TK,
	
	/**
	 * TONGA
	 */
	TO,
	
	/**
	 * TRINIDAD AND TOBAGO
	 */
	TT,
	
	/**
	 * TUNISIA
	 */
	TN,
	
	/**
	 * TURKEY
	 */
	TR,
	
	/**
	 * TURKMENISTAN
	 */
	TM,
	
	/**
	 * TURKS AND CAICOS ISLANDS
	 */
	TC,
	
	/**
	 * TUVALU
	 */
	TV,
	
	/**
	 * UGANDA
	 */
	UG,
	
	/**
	 * UKRAINE
	 */
	UA,
	
	/**
	 * UNITED ARAB EMIRATES
	 */
	AE,
	
	/**
	 * UNITED KINGDOM OF GREAT BRITAIN AND NORTHERN IRELAND
	 */
	GB,
	
	/**
	 * UNITED STATES
	 */
	US,
	
	/**
	 * UNITED STATES MINOR OUTLYING ISLANDS
	 */
	UM,
	
	/**
	 * URUGUAY
	 */
	UY,
	
	/**
	 * UZBEKISTAN
	 */
	UZ,
	
	/**
	 * VANUATU
	 */
	VU,
	
	/**
	 * VENEZUELA, BOLIVARIAN REPUBLIC OF
	 */
	VE,
	
	/**
	 * VIET NAM
	 */
	VN,
	
	/**
	 * VIRGIN ISLANDS, BRITISH
	 */
	VG,
	
	/**
	 * VIRGIN ISLANDS, U.S.
	 */
	VI,
	
	/**
	 * WALLIS AND FUTUNA
	 */
	WF,
	
	/**
	 * WESTERN SAHARA
	 */
	EH,
	
	/**
	 * YEMEN
	 */
	YE,
	
	/**
	 * ZAMBIA
	 */
	ZM,
	
	/**
	 * ZIMBABWE
	 */
	ZW,
	
	/**
	 * KOSOVO
	 */
	XK,
	
	/**
	 * STATELESS
	 */
	X_5,
	
	/**
	 * OTHER COUNTRY
	 */
	XX;
	
	public CountryCodeType toXmlType()
	{
		return switch(this)
		{
			case AF -> CountryCodeType.AF;
			case AX -> CountryCodeType.AX;
			case AL -> CountryCodeType.AL;
			case DZ -> CountryCodeType.DZ;
			case AS -> CountryCodeType.AS;
			case AD -> CountryCodeType.AD;
			case AO -> CountryCodeType.AO;
			case AI -> CountryCodeType.AI;
			case AQ -> CountryCodeType.AQ;
			case AG -> CountryCodeType.AG;
			case AR -> CountryCodeType.AR;
			case AM -> CountryCodeType.AM;
			case AW -> CountryCodeType.AW;
			case AU -> CountryCodeType.AU;
			case AT -> CountryCodeType.AT;
			case AZ -> CountryCodeType.AZ;
			case BS -> CountryCodeType.BS;
			case BH -> CountryCodeType.BH;
			case BD -> CountryCodeType.BD;
			case BB -> CountryCodeType.BB;
			case BY -> CountryCodeType.BY;
			case BE -> CountryCodeType.BE;
			case BZ -> CountryCodeType.BZ;
			case BJ -> CountryCodeType.BJ;
			case BM -> CountryCodeType.BM;
			case BT -> CountryCodeType.BT;
			case BO -> CountryCodeType.BO;
			case BQ -> CountryCodeType.BQ;
			case BA -> CountryCodeType.BA;
			case BW -> CountryCodeType.BW;
			case BV -> CountryCodeType.BV;
			case BR -> CountryCodeType.BR;
			case IO -> CountryCodeType.IO;
			case BN -> CountryCodeType.BN;
			case BG -> CountryCodeType.BG;
			case BF -> CountryCodeType.BF;
			case BI -> CountryCodeType.BI;
			case KH -> CountryCodeType.KH;
			case CM -> CountryCodeType.CM;
			case CA -> CountryCodeType.CA;
			case CV -> CountryCodeType.CV;
			case KY -> CountryCodeType.KY;
			case CF -> CountryCodeType.CF;
			case TD -> CountryCodeType.TD;
			case CL -> CountryCodeType.CL;
			case CN -> CountryCodeType.CN;
			case CX -> CountryCodeType.CX;
			case CC -> CountryCodeType.CC;
			case CO -> CountryCodeType.CO;
			case KM -> CountryCodeType.KM;
			case CG -> CountryCodeType.CG;
			case CD -> CountryCodeType.CD;
			case CK -> CountryCodeType.CK;
			case CR -> CountryCodeType.CR;
			case CI -> CountryCodeType.CI;
			case HR -> CountryCodeType.HR;
			case CU -> CountryCodeType.CU;
			case CW -> CountryCodeType.CW;
			case CY -> CountryCodeType.CY;
			case CZ -> CountryCodeType.CZ;
			case DK -> CountryCodeType.DK;
			case DJ -> CountryCodeType.DJ;
			case DM -> CountryCodeType.DM;
			case DO -> CountryCodeType.DO;
			case EC -> CountryCodeType.EC;
			case EG -> CountryCodeType.EG;
			case SV -> CountryCodeType.SV;
			case GQ -> CountryCodeType.GQ;
			case ER -> CountryCodeType.ER;
			case EE -> CountryCodeType.EE;
			case ET -> CountryCodeType.ET;
			case FK -> CountryCodeType.FK;
			case FO -> CountryCodeType.FO;
			case FJ -> CountryCodeType.FJ;
			case FI -> CountryCodeType.FI;
			case FR -> CountryCodeType.FR;
			case GF -> CountryCodeType.GF;
			case PF -> CountryCodeType.PF;
			case TF -> CountryCodeType.TF;
			case GA -> CountryCodeType.GA;
			case GM -> CountryCodeType.GM;
			case GE -> CountryCodeType.GE;
			case DE -> CountryCodeType.DE;
			case GH -> CountryCodeType.GH;
			case GI -> CountryCodeType.GI;
			case GR -> CountryCodeType.GR;
			case GL -> CountryCodeType.GL;
			case GD -> CountryCodeType.GD;
			case GP -> CountryCodeType.GP;
			case GU -> CountryCodeType.GU;
			case GT -> CountryCodeType.GT;
			case GG -> CountryCodeType.GG;
			case GN -> CountryCodeType.GN;
			case GW -> CountryCodeType.GW;
			case GY -> CountryCodeType.GY;
			case HT -> CountryCodeType.HT;
			case HM -> CountryCodeType.HM;
			case VA -> CountryCodeType.VA;
			case HN -> CountryCodeType.HN;
			case HK -> CountryCodeType.HK;
			case HU -> CountryCodeType.HU;
			case IS -> CountryCodeType.IS;
			case IN -> CountryCodeType.IN;
			case ID -> CountryCodeType.ID;
			case IR -> CountryCodeType.IR;
			case IQ -> CountryCodeType.IQ;
			case IE -> CountryCodeType.IE;
			case IM -> CountryCodeType.IM;
			case IL -> CountryCodeType.IL;
			case IT -> CountryCodeType.IT;
			case JM -> CountryCodeType.JM;
			case JP -> CountryCodeType.JP;
			case JE -> CountryCodeType.JE;
			case JO -> CountryCodeType.JO;
			case KZ -> CountryCodeType.KZ;
			case KE -> CountryCodeType.KE;
			case KI -> CountryCodeType.KI;
			case KP -> CountryCodeType.KP;
			case KR -> CountryCodeType.KR;
			case KW -> CountryCodeType.KW;
			case KG -> CountryCodeType.KG;
			case LA -> CountryCodeType.LA;
			case LV -> CountryCodeType.LV;
			case LB -> CountryCodeType.LB;
			case LS -> CountryCodeType.LS;
			case LR -> CountryCodeType.LR;
			case LY -> CountryCodeType.LY;
			case LI -> CountryCodeType.LI;
			case LT -> CountryCodeType.LT;
			case LU -> CountryCodeType.LU;
			case MO -> CountryCodeType.MO;
			case MK -> CountryCodeType.MK;
			case MG -> CountryCodeType.MG;
			case MW -> CountryCodeType.MW;
			case MY -> CountryCodeType.MY;
			case MV -> CountryCodeType.MV;
			case ML -> CountryCodeType.ML;
			case MT -> CountryCodeType.MT;
			case MH -> CountryCodeType.MH;
			case MQ -> CountryCodeType.MQ;
			case MR -> CountryCodeType.MR;
			case MU -> CountryCodeType.MU;
			case YT -> CountryCodeType.YT;
			case MX -> CountryCodeType.MX;
			case FM -> CountryCodeType.FM;
			case MD -> CountryCodeType.MD;
			case MC -> CountryCodeType.MC;
			case MN -> CountryCodeType.MN;
			case ME -> CountryCodeType.ME;
			case MS -> CountryCodeType.MS;
			case MA -> CountryCodeType.MA;
			case MZ -> CountryCodeType.MZ;
			case MM -> CountryCodeType.MM;
			case NA -> CountryCodeType.NA;
			case NR -> CountryCodeType.NR;
			case NP -> CountryCodeType.NP;
			case NL -> CountryCodeType.NL;
			case NC -> CountryCodeType.NC;
			case NZ -> CountryCodeType.NZ;
			case NI -> CountryCodeType.NI;
			case NE -> CountryCodeType.NE;
			case NG -> CountryCodeType.NG;
			case NU -> CountryCodeType.NU;
			case NF -> CountryCodeType.NF;
			case MP -> CountryCodeType.MP;
			case NO -> CountryCodeType.NO;
			case OM -> CountryCodeType.OM;
			case PK -> CountryCodeType.PK;
			case PW -> CountryCodeType.PW;
			case PS -> CountryCodeType.PS;
			case PA -> CountryCodeType.PA;
			case PG -> CountryCodeType.PG;
			case PY -> CountryCodeType.PY;
			case PE -> CountryCodeType.PE;
			case PH -> CountryCodeType.PH;
			case PN -> CountryCodeType.PN;
			case PL -> CountryCodeType.PL;
			case PT -> CountryCodeType.PT;
			case PR -> CountryCodeType.PR;
			case QA -> CountryCodeType.QA;
			case RE -> CountryCodeType.RE;
			case RO -> CountryCodeType.RO;
			case RU -> CountryCodeType.RU;
			case RW -> CountryCodeType.RW;
			case BL -> CountryCodeType.BL;
			case SH -> CountryCodeType.SH;
			case KN -> CountryCodeType.KN;
			case LC -> CountryCodeType.LC;
			case MF -> CountryCodeType.MF;
			case PM -> CountryCodeType.PM;
			case VC -> CountryCodeType.VC;
			case WS -> CountryCodeType.WS;
			case SM -> CountryCodeType.SM;
			case ST -> CountryCodeType.ST;
			case SA -> CountryCodeType.SA;
			case SN -> CountryCodeType.SN;
			case RS -> CountryCodeType.RS;
			case SC -> CountryCodeType.SC;
			case SL -> CountryCodeType.SL;
			case SG -> CountryCodeType.SG;
			case SX -> CountryCodeType.SX;
			case SK -> CountryCodeType.SK;
			case SI -> CountryCodeType.SI;
			case SB -> CountryCodeType.SB;
			case SO -> CountryCodeType.SO;
			case ZA -> CountryCodeType.ZA;
			case GS -> CountryCodeType.GS;
			case SS -> CountryCodeType.SS;
			case ES -> CountryCodeType.ES;
			case LK -> CountryCodeType.LK;
			case SD -> CountryCodeType.SD;
			case SR -> CountryCodeType.SR;
			case SJ -> CountryCodeType.SJ;
			case SZ -> CountryCodeType.SZ;
			case SE -> CountryCodeType.SE;
			case CH -> CountryCodeType.CH;
			case SY -> CountryCodeType.SY;
			case TW -> CountryCodeType.TW;
			case TJ -> CountryCodeType.TJ;
			case TZ -> CountryCodeType.TZ;
			case TH -> CountryCodeType.TH;
			case TL -> CountryCodeType.TL;
			case TG -> CountryCodeType.TG;
			case TK -> CountryCodeType.TK;
			case TO -> CountryCodeType.TO;
			case TT -> CountryCodeType.TT;
			case TN -> CountryCodeType.TN;
			case TR -> CountryCodeType.TR;
			case TM -> CountryCodeType.TM;
			case TC -> CountryCodeType.TC;
			case TV -> CountryCodeType.TV;
			case UG -> CountryCodeType.UG;
			case UA -> CountryCodeType.UA;
			case AE -> CountryCodeType.AE;
			case GB -> CountryCodeType.GB;
			case US -> CountryCodeType.US;
			case UM -> CountryCodeType.UM;
			case UY -> CountryCodeType.UY;
			case UZ -> CountryCodeType.UZ;
			case VU -> CountryCodeType.VU;
			case VE -> CountryCodeType.VE;
			case VN -> CountryCodeType.VN;
			case VG -> CountryCodeType.VG;
			case VI -> CountryCodeType.VI;
			case WF -> CountryCodeType.WF;
			case EH -> CountryCodeType.EH;
			case YE -> CountryCodeType.YE;
			case ZM -> CountryCodeType.ZM;
			case ZW -> CountryCodeType.ZW;
			case XK -> CountryCodeType.XK;
			case X_5 -> CountryCodeType.X_5;
			case XX -> CountryCodeType.XX;
		};
	}
}
