/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.utils;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.config.TestConfiguration;
import software.tnb.common.exception.FailureConditionMetException;
import software.tnb.common.exception.TimeoutException;

public final class WaitUtils {
    private static final Logger LOG = LoggerFactory.getLogger(WaitUtils.class);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(1);

    private WaitUtils() {
    }

    public static void sleep(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void waitFor(BooleanSupplier check, String logMessage) throws TimeoutException {
        WaitUtils.waitFor(check, 24, 5000L, logMessage);
    }

    public static void waitFor(BooleanSupplier resourceCheck, int retries, long waitTime, String logMessage) throws TimeoutException {
        boolean state;
        LOG.info(logMessage);
        do {
            if (state = resourceCheck.getAsBoolean()) continue;
            LOG.debug("Condition not met yet, sleeping for {}", (Object)waitTime);
            --retries;
            WaitUtils.sleep(waitTime);
        } while (!state && retries > 0);
        if (!state) {
            throw new TimeoutException("Timeout exceeded");
        }
        LOG.debug("Done waiting");
    }

    public static void waitFor(BooleanSupplier check, BooleanSupplier fail, long timeout, String logMessage) throws FailureConditionMetException {
        LOG.info(logMessage);
        Instant start = Instant.now();
        while (!check.getAsBoolean()) {
            if (fail.getAsBoolean()) {
                throw new FailureConditionMetException("Specified fail condition met");
            }
            if (Duration.between(start, Instant.now()).compareTo(TestConfiguration.testWaitKillTimeout()) > 0) {
                LOG.error("Wait killed after {} minutes", (Object)TestConfiguration.testWaitKillTimeout().toMinutes());
                break;
            }
            LOG.debug("Condition not met yet, sleeping for {}", (Object)timeout);
            WaitUtils.sleep(timeout);
        }
        LOG.debug("Done waiting");
    }

    public static <T> T withTimeout(Callable<T> callable) {
        return WaitUtils.withTimeout(callable, TestConfiguration.testWaitTime());
    }

    public static <T> T withTimeout(Callable<T> callable, Duration waitTime) {
        Instant end = Instant.now().plus(waitTime);
        Future<T> future = EXECUTOR_SERVICE.submit(callable);
        while (Instant.now().isBefore(end) && !future.isDone()) {
            WaitUtils.sleep(100L);
        }
        if (!future.isDone()) {
            future.cancel(true);
            throw new TimeoutException("Timeout exceeded");
        }
        try {
            return future.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get callable result: ", e);
        }
    }
}

