/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.utils.HTTPUtils;

public final class VersionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(VersionUtils.class);
    private static final String RELEASES_LATEST_URL = "https://api.github.com/repos/%s/releases/latest";
    private static VersionUtils instance;
    private static final Map<String, String> cache;

    private VersionUtils() {
    }

    public static VersionUtils getInstance() {
        instance = Optional.ofNullable(instance).orElseGet(VersionUtils::new);
        return instance;
    }

    public String getLatestGitHubReleaseTag(String githubRepo, String fallbackValue) {
        return cache.computeIfAbsent(githubRepo, k -> {
            HTTPUtils.Response response = HTTPUtils.getInstance().get(String.format(RELEASES_LATEST_URL, k), false);
            String version = null;
            if (response.isSuccessful()) {
                try {
                    version = ((JsonNode)new ObjectMapper().readValue(response.getBody(), JsonNode.class)).get("tag_name").textValue();
                }
                catch (Exception e) {
                    LOG.warn("error on getting response from github repo {}: {}", k, (Object)e.getMessage());
                }
            }
            return version != null ? version : fallbackValue;
        });
    }

    static {
        cache = new ConcurrentHashMap<String, String>();
    }
}

