/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.utils;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import software.tnb.common.utils.StringUtils;

public final class PropertiesUtils {
    private PropertiesUtils() {
    }

    public static Properties toCamelCaseProperties(Properties underscoreProperties) {
        Properties camelCaseProperties = new Properties();
        underscoreProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> camelCaseProperties.put(StringUtils.replaceUnderscoreWithCamelCase(key.toString()), value)));
        return camelCaseProperties;
    }

    public static String toString(Properties properties) {
        return PropertiesUtils.toString(properties, "");
    }

    public static String toString(Properties properties, String prefix) {
        return properties.entrySet().stream().map(entry -> prefix + entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(System.lineSeparator()));
    }

    public static Map<String, Object> toMap(Properties properties, String prefix) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (properties != null) {
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> map.put(Optional.ofNullable(prefix).orElse("") + StringUtils.replaceUnderscoreWithCamelCase(key.toString()), value)));
        }
        return map;
    }

    public static String toUriParameters(Properties properties) {
        return PropertiesUtils.toString(properties).replaceAll("\n", "&");
    }

    public static Properties fromFile(String filePath) {
        Properties properties = new Properties();
        try (FileInputStream is = new FileInputStream(filePath);){
            properties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load properties from " + filePath, e);
        }
        return properties;
    }
}

