/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.utils;

import java.net.ServerSocket;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.utils.WaitUtils;

public final class NetworkUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetworkUtils.class);
    private static final Set<Integer> ALLOCATED_PORTS = ConcurrentHashMap.newKeySet();

    private NetworkUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getFreePort() {
        try {
            while (true) {
                ServerSocket serverSocket = new ServerSocket(0);
                try {
                    int port = serverSocket.getLocalPort();
                    if (ALLOCATED_PORTS.contains(port)) {
                        LOG.trace("Waiting, port {} already allocated", (Object)port);
                        WaitUtils.sleep(500L);
                        continue;
                    }
                    LOG.trace("Allocated free port {}", (Object)port);
                    ALLOCATED_PORTS.add(port);
                    int n = port;
                    return n;
                }
                finally {
                    serverSocket.close();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to allocate a new port", e);
        }
    }

    public static void releasePort(int port) {
        LOG.trace("Releasing port {}", (Object)port);
        ALLOCATED_PORTS.remove(port);
    }
}

