/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.utils;

import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public final class MapUtils {
    private MapUtils() {
    }

    public static Properties toProperties(Map<String, String> map) {
        Properties properties = new Properties();
        properties.putAll(map);
        return properties;
    }

    public static List<EnvVar> toEnvVars(Map<String, String> map) {
        return map.entrySet().stream().map(e -> new EnvVar((String)e.getKey(), (String)e.getValue(), null)).collect(Collectors.toList());
    }

    public static Map<String, Object> merge(Map<String, Object> m1, Map<String, Object> m2) {
        HashMap<String, Object> result = new HashMap<String, Object>(m1);
        for (Map.Entry<String, Object> e : m2.entrySet()) {
            if (e.getValue() instanceof Map) {
                result.put(e.getKey(), MapUtils.merge(MapUtils.castToMap(result.computeIfAbsent(e.getKey(), v -> new HashMap())), MapUtils.castToMap(e.getValue())));
                continue;
            }
            if (e.getValue() instanceof List) {
                ArrayList<Object> list = new ArrayList<Object>(MapUtils.castToList(result.computeIfAbsent(e.getKey(), v -> new ArrayList())));
                list.addAll(MapUtils.castToList(e.getValue()));
                result.put(e.getKey(), list);
                continue;
            }
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    private static Map<String, Object> castToMap(Object o) {
        return (Map)o;
    }

    private static List<Object> castToList(Object o) {
        return (List)o;
    }
}

