/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Stack;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.ClassTestDescriptor;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.config.TestConfiguration;

public final class JUnitUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JUnitUtils.class);

    private JUnitUtils() {
    }

    public static boolean isExtensionStillNeeded(ExtensionContext extensionContext, Class<?> extensionClass) {
        if (TestConfiguration.parallel()) {
            return false;
        }
        try {
            Field f = Class.forName("org.junit.jupiter.engine.descriptor.AbstractExtensionContext").getDeclaredField("testDescriptor");
            TestDescriptor rootTestDescriptor = (TestDescriptor)ReflectionUtils.tryToReadFieldValue((Field)f, (Object)extensionContext.getRoot()).get();
            TestDescriptor currentTestDescriptor = (TestDescriptor)ReflectionUtils.tryToReadFieldValue((Field)f, (Object)extensionContext).get();
            ArrayList testClassesPlan = new ArrayList(rootTestDescriptor.getChildren());
            HashSet<ClassBasedTestDescriptor> testClasses = new HashSet<ClassBasedTestDescriptor>();
            for (int i = testClassesPlan.indexOf(currentTestDescriptor) + 1; i < testClassesPlan.size(); ++i) {
                ClassTestDescriptor classTestDescriptor = (ClassTestDescriptor)testClassesPlan.get(i);
                Stack<ClassTestDescriptor> descriptorsToProcess = new Stack<ClassTestDescriptor>();
                descriptorsToProcess.add(classTestDescriptor);
                while (!descriptorsToProcess.empty()) {
                    TestDescriptor desc = (TestDescriptor)descriptorsToProcess.pop();
                    if (desc.isContainer()) {
                        descriptorsToProcess.addAll(desc.getChildren());
                    }
                    if (!(desc instanceof ClassBasedTestDescriptor)) continue;
                    testClasses.add((ClassBasedTestDescriptor)desc);
                }
            }
            boolean found = testClasses.stream().anyMatch(it -> AnnotationSupport.findAnnotatedFieldValues((Class)it.getTestClass(), RegisterExtension.class).stream().anyMatch(extensionClass::isInstance));
            if (!found) {
                LOG.debug("JUnit: No more usages of {} found", (Object)extensionClass.getSimpleName());
            } else {
                LOG.debug("JUnit: {} will be used in next tests", (Object)extensionClass.getSimpleName());
            }
            return found;
        }
        catch (Exception e) {
            LOG.debug("JUnit: Unable to check for extension class usages, returning false");
            LOG.trace("Exception while checking: ", (Throwable)e);
            return false;
        }
    }
}

