/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.config.TestConfiguration;

public final class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
    }

    public static void writeFile(Path file, String content) {
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.write(file, content.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write to " + file, e);
        }
    }

    public static void copyFile(Path source, Path target) {
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to copy to " + source, e);
        }
    }

    public static String readFile(Path file) {
        try {
            return Files.readString(file, Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read file " + file, e);
        }
    }

    public static Path createTar(final Path f) {
        Path output;
        try {
            output = Files.createTempFile(TestConfiguration.appLocation(), "tar", ".tar", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create temp file: ", e);
        }
        try (final TarArchiveOutputStream archive = new TarArchiveOutputStream(Files.newOutputStream(output, new OpenOption[0]));){
            archive.setLongFileMode(3);
            if (!f.toFile().isDirectory()) {
                IOUtils.addTarEntry(archive, f, f.getFileName().toString());
            } else {
                Files.walkFileTree(f, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                        if (attributes.isSymbolicLink()) {
                            return FileVisitResult.CONTINUE;
                        }
                        Path targetFile = f.relativize(file);
                        IOUtils.addTarEntry(archive, file, targetFile.toString());
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            archive.finish();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create tar file: ", e);
        }
        return output;
    }

    private static void addTarEntry(TarArchiveOutputStream taos, Path file, String fileName) {
        try {
            TarArchiveEntry tarEntry = new TarArchiveEntry(file.toFile(), fileName);
            taos.putArchiveEntry((ArchiveEntry)tarEntry);
            Files.copy(file, (OutputStream)taos);
            taos.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create tar entry: ", e);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        org.apache.commons.io.IOUtils.closeQuietly((Closeable)closeable, e -> LOG.warn("Could not close resource", (Throwable)e));
    }

    public static void createDirectory(File f) {
        if (!f.exists() && !f.mkdirs()) {
            LOG.debug("Creating new directory {}", (Object)f.getAbsolutePath());
            throw new RuntimeException("Unable to create directory " + f.getAbsolutePath());
        }
    }

    public static void createDirectory(Path p) {
        IOUtils.createDirectory(p.toFile());
    }

    public static void copyDirectory(Path from, Path to) {
        try {
            LOG.debug("Copying directory {} to {}", (Object)from.toAbsolutePath(), (Object)to.toAbsolutePath());
            FileUtils.copyDirectory((File)from.toFile(), (File)to.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to copy directories: ", e);
        }
    }

    public static void replaceVariables(Path input, Properties keysValues, Path output) {
        String withVars = IOUtils.readFile(input);
        for (Object key : keysValues.keySet()) {
            withVars = withVars.replaceAll("\\$\\{" + key + "\\}", keysValues.getProperty(key.toString()));
        }
        IOUtils.writeFile(output, withVars);
    }

    public static void replaceInFile(Path input, Map<String, String> replacement) {
        Assertions.assertTrue((input != null && input.toFile().canWrite() ? 1 : 0) != 0);
        Assertions.assertNotNull(replacement);
        AtomicReference<String> content = new AtomicReference<String>(IOUtils.readFile(input));
        replacement.entrySet().forEach(e -> content.getAndUpdate(val -> val.replaceAll((String)e.getKey(), (String)e.getValue())));
        IOUtils.writeFile(input, content.get());
    }

    public static Path zipFiles(String zipFileName, Path ... files) {
        Path zipFile;
        LOG.info("Creating zip file {}.zip from files: {}", (Object)zipFileName, Arrays.stream(files).map(f -> f.getFileName().toString()).collect(Collectors.toList()));
        try {
            zipFile = Files.createFile(Paths.get("/tmp", zipFileName + ".zip"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create temp zip file: ", e);
        }
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile.toFile()));){
            for (Path file : files) {
                ZipEntry e = new ZipEntry(file.getFileName().toString());
                zos.putNextEntry(e);
                zos.write(IOUtils.readFile(file).getBytes());
                zos.closeEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to add file to zip file: ", e);
        }
        return zipFile;
    }

    public static String getExecInPath(String execName) {
        return Arrays.stream(System.getenv("PATH").split(File.pathSeparator)).map(x$0 -> Path.of(x$0, new String[0])).filter(pathEntry -> {
            try {
                return Files.find(pathEntry, 1, (filePath, basicFileAttributes) -> Files.exists(filePath, new LinkOption[0]) && !Files.isDirectory(filePath, new LinkOption[0]) && filePath.getFileName().toString().equals(execName), new FileVisitOption[0]).count() > 0L;
            }
            catch (IOException e) {
                return false;
            }
        }).map(p -> p.resolve(execName).toAbsolutePath().toString()).findFirst().orElse(null);
    }
}

