/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.utils;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.utils.FIPSUtils;

public final class HTTPUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPUtils.class);
    private static HTTPUtils instance;
    private final OkHttpClient client;
    private static final TrustManager[] trustAllCerts;
    private static final SSLContext sslContext;

    private HTTPUtils(OkHttpClient client) {
        this.client = client;
    }

    public Response get(String url, boolean throwError) {
        return this.execute(new Request.Builder().get().url(url).build(), throwError);
    }

    public Response get(String url) {
        return this.get(url, true);
    }

    public Response get(String url, Map<String, String> headers) {
        return this.execute(new Request.Builder().get().url(url).headers(Headers.of(headers)).build(), true);
    }

    public Response post(String url, RequestBody body) {
        return this.execute(new Request.Builder().post(body).url(url).build(), true);
    }

    public Response post(String url, RequestBody body, Map<String, String> headers) {
        return this.execute(new Request.Builder().post(body).url(url).headers(Headers.of(headers)).build(), true);
    }

    public Response put(String url, RequestBody body, Map<String, String> headers) {
        return this.execute(new Request.Builder().put(body).url(url).headers(Headers.of(headers)).build(), true);
    }

    public Response put(String url, RequestBody body) {
        return this.execute(new Request.Builder().put(body).url(url).build(), true);
    }

    public void delete(String url) {
        this.execute(new Request.Builder().url(url).delete().build(), true);
    }

    public void delete(String url, Map<String, String> headers) {
        this.execute(new Request.Builder().url(url).delete().headers(Headers.of(headers)).build(), true);
    }

    private Response execute(Request request, boolean throwError) {
        try {
            okhttp3.Response response = this.client.newCall(request).execute();
            String responseBody = null;
            if (response.body() != null) {
                responseBody = response.body().string();
                response.body().close();
            }
            return new Response(response.code(), responseBody);
        }
        catch (IOException e) {
            if (throwError) {
                throw new RuntimeException("Unable to execute request: ", e);
            }
            LOG.warn("execute error is ignored: {}", (Object)e.getMessage());
            return new Response(0, null);
        }
    }

    public static HTTPUtils getInstance() {
        if (instance == null) {
            instance = new HTTPUtils(new OkHttpClient());
        }
        return instance;
    }

    public static HTTPUtils getInstance(OkHttpClient client) {
        return new HTTPUtils(client);
    }

    public static SSLContext getSslContext() {
        return sslContext;
    }

    public static OkHttpClient trustAllSslClient() {
        OkHttpClient.Builder builder = new OkHttpClient().newBuilder();
        builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustAllCerts[0]);
        builder.hostnameVerifier((hostname, session) -> true);
        return builder.build();
    }

    static {
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            if (FIPSUtils.isFipsEnabled()) {
                sslContext = SSLContext.getDefault();
            } else {
                sslContext = SSLContext.getInstance("SSL");
                sslContext.init(null, trustAllCerts, new SecureRandom());
            }
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static class OkHttpClientBuilder {
        private OkHttpClient.Builder builder = new OkHttpClient().newBuilder();

        public OkHttpClientBuilder trustAllSslClient() {
            this.builder.sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustAllCerts[0]);
            this.builder.hostnameVerifier((hostname, session) -> true);
            return this;
        }

        public OkHttpClientBuilder log() {
            HttpLoggingInterceptor logger = new HttpLoggingInterceptor();
            logger.setLevel(HttpLoggingInterceptor.Level.BODY);
            this.builder.addInterceptor((Interceptor)logger);
            return this;
        }

        public OkHttpClient.Builder getInternalBuilder() {
            return this.builder;
        }

        public OkHttpClient build() {
            return this.builder.build();
        }
    }

    public static class Response {
        int responseCode;
        String body;

        public Response(int responseCode, String body) {
            this.responseCode = responseCode;
            this.body = body;
        }

        public int getResponseCode() {
            return this.responseCode;
        }

        public String getBody() {
            return this.body;
        }

        public boolean isSuccessful() {
            return this.responseCode >= 200 && this.responseCode < 300;
        }
    }
}

