/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.openshift;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.config.TestConfiguration;
import software.tnb.common.openshift.OpenshiftClient;

public class OpenshiftClientWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftClientWrapper.class);
    private final ThreadLocal<OpenshiftClient> threadLocalClient = new ThreadLocal();
    private OpenshiftClient openshiftClient;
    private final Supplier<OpenshiftClient> supplier;

    public OpenshiftClientWrapper(Supplier<OpenshiftClient> clientInit) {
        this.supplier = clientInit;
        this.init();
    }

    public void init() {
        if (TestConfiguration.parallel()) {
            this.threadLocalClient.set(this.supplier.get());
            Thread.currentThread().setName(Thread.currentThread().getName() + "|" + this.threadLocalClient.get().getNamespace());
        } else {
            this.openshiftClient = this.supplier.get();
        }
    }

    public OpenshiftClient getClient() {
        return TestConfiguration.parallel() ? this.threadLocalClient.get() : this.openshiftClient;
    }

    public void closeClient() {
        if (TestConfiguration.parallel()) {
            LOG.trace("Closing OpenShift client in thread " + Thread.currentThread().getName());
            Thread.currentThread().setName(Thread.currentThread().getName().replace("|" + this.getClient().getNamespace(), ""));
        }
        this.getClient().close();
        this.threadLocalClient.set(null);
        this.openshiftClient = null;
    }
}

