/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.openshift;

import cz.xtf.core.openshift.OpenShift;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.SecurityContextConstraints;
import io.fabric8.openshift.api.model.SecurityContextConstraintsBuilder;
import io.fabric8.openshift.api.model.SecurityContextConstraintsFluent;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroup;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupFluent;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupList;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlan;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.Subscription;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionConfig;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionFluent;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.OpenShiftConfigBuilder;
import io.fabric8.openshift.client.dsl.BuildConfigResource;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.config.OpenshiftConfiguration;
import software.tnb.common.config.TestConfiguration;
import software.tnb.common.openshift.OpenshiftClientWrapper;
import software.tnb.common.utils.HTTPUtils;
import software.tnb.common.utils.IOUtils;
import software.tnb.common.utils.PropertiesUtils;
import software.tnb.common.utils.WaitUtils;

public class OpenshiftClient
extends OpenShift {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftClient.class);
    protected static OpenshiftClientWrapper clientWrapper;

    protected OpenshiftClient(OpenShiftConfig openShiftConfig) {
        super(openShiftConfig);
    }

    private static OpenshiftClient createInstance() {
        OpenShiftConfigBuilder configBuilder;
        if (OpenshiftConfiguration.openshiftUrl() != null) {
            configBuilder = (OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(OpenshiftConfiguration.openshiftUrl())).withUsername(OpenshiftConfiguration.openshiftUsername())).withPassword(OpenshiftConfiguration.openshiftPassword());
        } else if (OpenshiftConfiguration.openshiftKubeconfig() != null) {
            configBuilder = new OpenShiftConfigBuilder(new OpenShiftConfig(Config.fromKubeconfig((String)IOUtils.readFile(OpenshiftConfiguration.openshiftKubeconfig()))));
        } else {
            LOG.info("Auto-configuring openshift client");
            configBuilder = new OpenShiftConfigBuilder(new OpenShiftConfig(Config.autoConfigure(null)));
        }
        String namespace = OpenshiftConfiguration.openshiftNamespace();
        ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)configBuilder.withNamespace(namespace)).withHttpsProxy(OpenshiftConfiguration.openshiftHttpsProxy())).withBuildTimeout(60000L)).withRequestTimeout(120000)).withConnectionTimeout(120000)).withTrustCerts(true);
        LOG.info("Using cluster {}", (Object)configBuilder.getMasterUrl());
        return new OpenshiftClient(configBuilder.build());
    }

    private static OpenshiftClient init() {
        OpenshiftClient c = OpenshiftClient.createInstance();
        c.createNamespace(c.getNamespace());
        return c;
    }

    public static synchronized OpenshiftClient get() {
        if (clientWrapper == null) {
            clientWrapper = new OpenshiftClientWrapper(OpenshiftClient::init);
        } else if (clientWrapper.getClient() == null) {
            clientWrapper.init();
        }
        return clientWrapper.getClient();
    }

    public String getOauthToken() {
        if (OpenshiftConfiguration.openshiftUrl() == null) {
            return OpenshiftClient.get().authorization().getConfiguration().getOauthToken();
        }
        return OpenshiftClient.getTokenByUsernameAndPassword(OpenshiftConfiguration.openshiftUsername(), OpenshiftConfiguration.openshiftPassword(), OpenshiftConfiguration.openshiftUrl());
    }

    private static String getTokenByUsernameAndPassword(String username, String password, String openshiftUrl) {
        try {
            String openshiftHost = new URI(openshiftUrl).getHost().replaceFirst("api.", "");
            OkHttpClient httpClient = new HTTPUtils.OkHttpClientBuilder().trustAllSslClient().getInternalBuilder().followRedirects(false).build();
            Request request = new Request.Builder().get().url("https://oauth-openshift.apps." + openshiftHost + "/oauth/authorize?response_type=token&client_id=openshift-challenging-client").headers(Headers.of((String[])new String[]{"Authorization", "Basic " + Base64.getEncoder().encodeToString((username + ":" + password).getBytes())})).build();
            Response response = httpClient.newCall(request).execute();
            Pattern p = Pattern.compile("(?<=access_token=)[^&]+");
            Matcher m = p.matcher(new URI(response.headers().get("Location")).getFragment());
            if (m.find()) {
                return m.group(0);
            }
            throw new IllegalStateException("Oauth token not found");
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T> T inNamespace(String ns, Function<OpenshiftClient, T> function) {
        T result;
        String currentNs = OpenshiftClient.get().config.getNamespace();
        OpenshiftClient.get().config.setNamespace(ns);
        try {
            result = function.apply(OpenshiftClient.get());
        }
        finally {
            OpenshiftClient.get().config.setNamespace(currentNs);
        }
        return result;
    }

    public void createSubscription(String channel, String operatorName, String source, String subscriptionName) {
        this.createSubscription(channel, operatorName, source, subscriptionName, "openshift-marketplace", OpenshiftClient.get().getNamespace(), false);
    }

    public void createSubscription(String channel, String operatorName, String source, String subscriptionName, String subscriptionNamespace) {
        this.createSubscription(channel, operatorName, source, subscriptionName, subscriptionNamespace, OpenshiftClient.get().getNamespace(), false);
    }

    public void createSubscription(String channel, String operatorName, String source, String subscriptionName, String subscriptionSourceNamespace, String targetNamespace, boolean clusterWide) {
        this.createSubscription(channel, operatorName, source, subscriptionName, subscriptionSourceNamespace, targetNamespace, clusterWide, null);
    }

    public void createSubscription(String channel, String operatorName, String source, String subscriptionName, String subscriptionSourceNamespace, String targetNamespace, boolean clusterWide, String startingWithCSV) {
        this.createSubscription(channel, operatorName, source, subscriptionName, subscriptionSourceNamespace, targetNamespace, clusterWide, startingWithCSV, null);
    }

    public void createSubscription(String channel, String operatorName, String source, String subscriptionName, String subscriptionSourceNamespace, String targetNamespace, boolean clusterWide, String startingWithCSV, SubscriptionConfig config) {
        LOG.info("Creating subcription with name \"{}\", for operator \"{}\", channel \"{}\", catalog source \"{}\" from \"{}\" namespace", new Object[]{subscriptionName, operatorName, channel, source, subscriptionSourceNamespace});
        if (((OperatorGroupList)((NonNamespaceOperation)OpenshiftClient.get().operatorHub().operatorGroups().inNamespace(targetNamespace)).list()).getItems().size() == 0) {
            LOG.debug("Creating operator group {}", (Object)subscriptionName);
            OperatorGroupBuilder operatorGroupBuilder = (OperatorGroupBuilder)((OperatorGroupFluent.MetadataNested)new OperatorGroupBuilder().withNewMetadata().withName(subscriptionName)).endMetadata();
            if (!clusterWide) {
                ((OperatorGroupFluent.SpecNested)operatorGroupBuilder.withNewSpec().withTargetNamespaces(new String[]{targetNamespace})).endSpec();
            }
            ((NonNamespaceOperation)OpenshiftClient.get().operatorHub().operatorGroups().inNamespace(targetNamespace)).createOrReplace((Object[])new OperatorGroup[]{operatorGroupBuilder.build()});
        }
        Subscription s = ((SubscriptionBuilder)((SubscriptionFluent.SpecNested)((SubscriptionFluent.SpecNested)((SubscriptionFluent.SpecNested)((SubscriptionFluent.SpecNested)((SubscriptionFluent.SpecNested)((SubscriptionFluent.SpecNested)((SubscriptionBuilder)((SubscriptionFluent.MetadataNested)new SubscriptionBuilder().editOrNewMetadata().withName(subscriptionName)).endMetadata()).withNewSpec().withName(operatorName)).withChannel(channel)).withSource(source)).withSourceNamespace(subscriptionSourceNamespace)).withStartingCSV(startingWithCSV)).withConfig(config)).endSpec()).build();
        ((NonNamespaceOperation)OpenshiftClient.get().operatorHub().subscriptions().inNamespace(targetNamespace)).createOrReplace((Object[])new Subscription[]{s});
    }

    public void waitForInstallPlanToComplete(String subscriptionName) {
        this.waitForInstallPlanToComplete(subscriptionName, OpenshiftClient.get().getNamespace());
    }

    public void waitForInstallPlanToComplete(String subscriptionName, String targetNamespace) {
        WaitUtils.waitFor(() -> {
            Subscription subscription = (Subscription)((Resource)((NonNamespaceOperation)OpenshiftClient.get().operatorHub().subscriptions().inNamespace(targetNamespace)).withName(subscriptionName)).get();
            if (subscription == null || subscription.getStatus() == null || subscription.getStatus().getInstallplan() == null) {
                return false;
            }
            String ipName = subscription.getStatus().getInstallplan().getName();
            InstallPlan installPlan = (InstallPlan)((Resource)((NonNamespaceOperation)OpenshiftClient.get().operatorHub().installPlans().inNamespace(targetNamespace)).withName(ipName)).get();
            if (installPlan == null || installPlan.getStatus() == null || installPlan.getStatus().getPhase() == null) {
                return false;
            }
            return installPlan.getStatus().getPhase().equalsIgnoreCase("complete");
        }, 50, 5000L, String.format("Waiting until the install plan from subscription %s is complete", subscriptionName));
    }

    public void deleteSubscription(String name) {
        this.deleteSubscription(name, OpenshiftClient.get().getNamespace());
    }

    public void deleteSubscription(String name, String namespace) {
        LOG.info("Deleting subscription {} in namespace {}", (Object)name, (Object)namespace);
        Subscription subscription = (Subscription)((Resource)((NonNamespaceOperation)OpenshiftClient.get().operatorHub().subscriptions().inNamespace(namespace)).withName(name)).get();
        if (subscription == null) {
            LOG.warn("Unable to find subscription {} in {} namespace, skipping delete", (Object)name, (Object)namespace);
            return;
        }
        String csvName = subscription.getStatus().getCurrentCSV();
        if (csvName != null) {
            ((Resource)((NonNamespaceOperation)OpenshiftClient.get().operatorHub().clusterServiceVersions().inNamespace(namespace)).withName(csvName)).delete();
        }
        ((Resource)((NonNamespaceOperation)OpenshiftClient.get().operatorHub().subscriptions().inNamespace(namespace)).withName(name)).delete();
    }

    public void waitForImageStream(String name, String tag) {
        WaitUtils.waitFor(() -> ((ImageStream)((Resource)OpenshiftClient.get().imageStreams().withName(name)).get()).getSpec().getTags().stream().anyMatch(t -> tag.equals(t.getName())), 24, 5000L, String.format("Waiting until the imagestream %s contains %s tag", name, tag));
    }

    public void doS2iBuild(String name, Path filePath) {
        LOG.info("Instantiating a new build for buildconfig {} from file {}", (Object)name, (Object)filePath.toAbsolutePath());
        ((BuildConfigResource)OpenshiftClient.get().buildConfigs().withName(name)).instantiateBinary().fromFile(filePath.toFile());
        BooleanSupplier success = () -> "complete".equalsIgnoreCase(OpenshiftClient.get().getBuild(name + "-" + OpenshiftClient.get().getBuildConfig(name).getStatus().getLastVersion()).getStatus().getPhase());
        BooleanSupplier fail = () -> "failed".equalsIgnoreCase(OpenshiftClient.get().getBuild(name + "-" + OpenshiftClient.get().getBuildConfig(name).getStatus().getLastVersion()).getStatus().getPhase());
        WaitUtils.waitFor(success, fail, 5000L, "Waiting until the build completes");
    }

    public void createNamespace(String name) {
        if (name == null || name.isEmpty()) {
            LOG.info("Skipped creating namespace, name null or empty");
            return;
        }
        Namespace namespace = (Namespace)((Resource)this.namespaces().withName(name)).get();
        if (namespace != null && namespace.getMetadata().getDeletionTimestamp() != null) {
            throw new RuntimeException("Namespace " + name + " already exists and is in Terminating state");
        }
        Map labels = TestConfiguration.user() == null ? Map.of() : Map.of("tnb/createdBy", TestConfiguration.user());
        Namespace ns = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(name)).withLabels(labels)).endMetadata()).build();
        if (((Resource)this.namespaces().withName(name)).get() == null) {
            this.namespaces().create((Object)ns);
            WaitUtils.waitFor(() -> ((Resource)this.namespaces().withName(name)).get() != null, "Waiting until the namespace " + name + " is created");
        } else {
            LOG.info("Skipped creating namespace " + name + ", already exists");
        }
    }

    public static void deleteNamespace() {
        if (clientWrapper != null && clientWrapper.getClient() != null) {
            OpenshiftClient.deleteNamespace(OpenshiftClient.get().getNamespace());
            clientWrapper.closeClient();
        }
    }

    public static void deleteNamespace(String name) {
        if (name == null || name.isEmpty()) {
            LOG.info("Skipped deleting namespace, name null or empty");
            return;
        }
        if (((Resource)OpenshiftClient.get().namespaces().withName(name)).get() == null) {
            LOG.info("Skipped deleting namespace " + name + ", not found");
        } else {
            ((EditReplacePatchDeletable)((Resource)OpenshiftClient.get().namespaces().withName(name)).cascading(true)).delete();
            WaitUtils.waitFor(() -> ((Resource)OpenshiftClient.get().namespaces().withName(name)).get() == null, "Waiting until the namespace is removed");
            LOG.info("Deleted namespace " + name);
        }
    }

    public ConfigMap createConfigMap(String name, Map<String, String> data) {
        return (ConfigMap)((Resource)OpenshiftClient.get().configMaps().withName(name)).createOrReplace((Object[])new ConfigMap[]{((ConfigMapBuilder)((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().withNewMetadata().withName(name)).endMetadata()).withData(data)).build()});
    }

    public String getLogs(Pod p) {
        return ((ContainerResource)((PodResource)OpenshiftClient.get().pods().withName(p.getMetadata().getName())).inContainer((Object)this.getIntegrationContainer(p))).getLog();
    }

    public Secret createApplicationPropertiesSecret(String name, Properties credentials, Map<String, String> labels, String prefix) {
        String credentialsString = PropertiesUtils.toString(credentials, Optional.ofNullable(prefix).orElse(""));
        String dataFileName = name.contains(".") ? name.substring(0, name.indexOf(".")) : name;
        Secret secret = ((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)((SecretBuilder)new SecretBuilder().withStringData(Collections.singletonMap(dataFileName + ".properties", credentialsString))).withNewMetadata().withName(name)).addToLabels(labels)).endMetadata()).build();
        return (Secret)OpenshiftClient.get().secrets().createOrReplace((Object[])new Secret[]{secret});
    }

    public void deleteSecret(String name) {
        ((Resource)OpenshiftClient.get().secrets().withName(name)).delete();
    }

    public String getClusterHostname(String service) {
        return String.format("%s.%s.svc.cluster.local", service, OpenshiftClient.get().getNamespace());
    }

    public boolean isPodFailed(Pod pod) {
        try {
            return pod.getStatus().getContainerStatuses().stream().anyMatch(p -> "error".equalsIgnoreCase(p.getState().getTerminated().getReason()) || "error".equalsIgnoreCase(p.getLastState().getTerminated().getReason()));
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public String getIntegrationContainer(Pod pod) {
        String container;
        List containerList = this.getAllContainers(pod);
        if (containerList.size() > 1) {
            Optional<Container> integrationContainer = containerList.stream().filter(c -> "integration".equalsIgnoreCase(c.getName())).findFirst();
            if (integrationContainer.isEmpty()) {
                throw new RuntimeException("There were multiple containers in pod and \"integration\" container was not present");
            }
            container = integrationContainer.get().getName();
        } else {
            container = ((Container)containerList.get(0)).getName();
        }
        return container;
    }

    public SecurityContextConstraints createSecurityContext(String sccName, String copyFromScc, String ... defaultCapabilities) {
        SecurityContextConstraints scc = (SecurityContextConstraints)((Resource)OpenshiftClient.get().securityContextConstraints().withName(sccName)).get();
        if (scc == null) {
            SecurityContextConstraints existingScc = (SecurityContextConstraints)((Resource)OpenshiftClient.get().securityContextConstraints().withName(copyFromScc)).get();
            scc = (SecurityContextConstraints)OpenshiftClient.get().securityContextConstraints().create((Object)((SecurityContextConstraintsBuilder)((SecurityContextConstraintsBuilder)((SecurityContextConstraintsFluent.MetadataNested)new SecurityContextConstraintsBuilder(existingScc).withNewMetadata().withName(sccName)).endMetadata()).addToDefaultAddCapabilities(defaultCapabilities)).build());
        }
        return scc;
    }

    public void addUsersToSecurityContext(SecurityContextConstraints scc, String ... users) {
        for (String user : users) {
            if (scc.getUsers().contains(user)) continue;
            scc.getUsers().add(user);
        }
        ((Resource)OpenshiftClient.get().securityContextConstraints().withName(scc.getMetadata().getName())).patch((Object)scc);
    }

    public void addGroupsToSecurityContext(SecurityContextConstraints scc, String ... groups) {
        for (String group : groups) {
            if (scc.getGroups().contains(group)) continue;
            scc.getGroups().add(group);
        }
        ((Resource)OpenshiftClient.get().securityContextConstraints().withName(scc.getMetadata().getName())).patch((Object)scc);
    }

    public String getServiceAccountRef(String serviceAccountName) {
        return "system:serviceaccount:" + OpenshiftClient.get().getNamespace() + ":" + serviceAccountName;
    }

    public boolean hasLabels(Pod pod, Map<String, String> expectedLabels) {
        Map labels = pod.getMetadata().getLabels();
        for (Map.Entry<String, String> expected : expectedLabels.entrySet()) {
            if (labels.containsKey(expected.getKey()) && ((String)labels.get(expected.getKey())).equals(expected.getValue())) continue;
            return false;
        }
        return true;
    }
}

