/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.tnb.common.config.Configuration;
import software.tnb.common.product.ProductType;
import software.tnb.common.utils.IOUtils;

public class TestConfiguration
extends Configuration {
    public static final String PRODUCT = "test.product";
    public static final String CREDENTIALS_FILE = "test.credentials.file";
    public static final String CREDENTIALS = "test.credentials";
    public static final String VAULT_TOKEN = "test.credentials.vault.token";
    private static final String VAULT_SECRET_ID = "test.credentials.vault.secret.id";
    private static final String VAULT_ROLE_ID = "test.credentials.vault.role.id";
    public static final String VAULT_ADDRESS = "test.credentials.vault.address";
    public static final String VAULT_PATH_PATTERN = "test.credentials.vault.path.pattern";
    public static final String APP_GROUP_ID = "test.app.group.id";
    public static final String APP_LOCATION = "app.location";
    public static final String APP_TEMPLATE_NAME = "app.template.name";
    public static final String TEST_WAIT_TIME = "test.wait.time";
    public static final String TEST_WAIT_KILL_TIMEOUT = "test.wait.kill.timeout";
    public static final String TEST_SKIP_TEARDOWN = "test.skip.teardown";
    public static final String TEST_SKIP_TEARDOWN_OPENSHIFT_AMQSTREAMS = "test.skip.teardown.openshift.amqstreams";
    public static final String MAVEN_REPOSITORY = "test.maven.repository";
    public static final String MAVEN_SETTINGS = "test.maven.settings";
    public static final String MAVEN_SETTINGS_FILE_NAME = "test.maven.settings.file.name";
    public static final String MAVEN_REPOSITORY_ID = "test.maven.repository.id";
    public static final String MAVEN_EXTRA_ARGS = "test.maven.extra.args";
    public static final String REPORT_PORTAL = "test.report.portal.enabled";
    public static final String ODO_PATH = "odo.path";
    public static final String STREAM_LOGS = "stream.logs";
    public static final String JIRA_ALLOWED_RESOLUTIONS = "jira.allowed.resolutions";
    public static final String JIRA_ACCESS_TOKEN = "jira.token";
    public static final String PARALLEL = "test.parallel";
    public static final String TEST_USE_GLOBAL_OPENSHIFT_KAFKA = "test.use.global.openshift.kafka";
    public static final String VARIABLE_PLACEHOLDER_START = "\\$\\{";
    public static final String VARIABLE_PLACEHOLDER_END = "\\}";
    public static final String USER = "tnb.user";

    public static ProductType product() {
        return Arrays.stream(ProductType.values()).filter(p -> p.getValue().equals(TestConfiguration.getProperty(PRODUCT))).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unable to find enum for system property %s = %s", PRODUCT, TestConfiguration.getProperty(PRODUCT))));
    }

    public static String vaultToken() {
        return TestConfiguration.getProperty(VAULT_TOKEN);
    }

    public static String vaultRoleId() {
        return TestConfiguration.getProperty(VAULT_ROLE_ID);
    }

    public static String vaultSecretId() {
        return TestConfiguration.getProperty(VAULT_SECRET_ID);
    }

    public static String vaultPathPattern() {
        return TestConfiguration.getProperty(VAULT_PATH_PATTERN, "/");
    }

    public static String vaultAddress() {
        return TestConfiguration.getProperty(VAULT_ADDRESS, "https://vault.devshift.net");
    }

    public static String credentialsFile() {
        return TestConfiguration.getProperty(CREDENTIALS_FILE);
    }

    public static String credentials() {
        return TestConfiguration.getProperty(CREDENTIALS);
    }

    public static String appGroupId() {
        return TestConfiguration.getProperty(APP_GROUP_ID, "com.test");
    }

    public static Path appLocation() {
        return Paths.get(TestConfiguration.getProperty(APP_LOCATION, "target"), new String[0]);
    }

    public static String appTemplateName() {
        return TestConfiguration.getProperty(APP_TEMPLATE_NAME, "tnb-app");
    }

    public static Duration testWaitTime() {
        return Duration.of(TestConfiguration.getInteger(TEST_WAIT_TIME, 60), ChronoUnit.SECONDS);
    }

    public static Duration testWaitKillTimeout() {
        return Duration.of(TestConfiguration.getInteger(TEST_WAIT_KILL_TIMEOUT, 120), ChronoUnit.MINUTES);
    }

    public static String mavenRepository() {
        return TestConfiguration.getProperty(MAVEN_REPOSITORY, "https://repository.jboss.org/nexus/content/groups/public/");
    }

    public static String mavenSettings() {
        return TestConfiguration.getProperty(MAVEN_SETTINGS);
    }

    public static String mavenExtraArgs() {
        return TestConfiguration.getProperty(MAVEN_EXTRA_ARGS, "");
    }

    public static String mavenSettingsFileName() {
        return TestConfiguration.getProperty(MAVEN_SETTINGS_FILE_NAME, "tnb-maven-settings.xml");
    }

    public static String mavenRepositoryId() {
        return TestConfiguration.getProperty(MAVEN_REPOSITORY_ID, "tnb-maven-repo");
    }

    public static boolean isMavenMirror() {
        return TestConfiguration.getProperty(MAVEN_REPOSITORY, "").contains("@mirrorOf=");
    }

    public static boolean skipTearDown() {
        return TestConfiguration.getBoolean(TEST_SKIP_TEARDOWN, false);
    }

    public static boolean skipTearDownOpenshiftAMQStreams() {
        return TestConfiguration.getBoolean(TEST_SKIP_TEARDOWN_OPENSHIFT_AMQSTREAMS, false);
    }

    public static boolean reportPortalEnabled() {
        return TestConfiguration.getBoolean(REPORT_PORTAL, false);
    }

    public static String user() {
        if (!"hudson".equals(System.getProperty("user.name"))) {
            return System.getProperty("user.name");
        }
        return System.getProperty(USER);
    }

    public static String odoPath() {
        return Optional.of(TestConfiguration.getProperty(ODO_PATH, () -> IOUtils.getExecInPath("odo"))).orElseThrow(() -> new RuntimeException("Unable to find odo command: please provide 'odo.path' property or add odo binary in system path"));
    }

    public static boolean streamLogs() {
        return TestConfiguration.getBoolean(STREAM_LOGS, false);
    }

    public static Set<String> jiraAllowedResolutions() {
        return Arrays.stream(TestConfiguration.getProperty(JIRA_ALLOWED_RESOLUTIONS, "Resolved, Closed, Done, Validation Backlog, In Validation").split(",")).map(String::trim).map(String::toLowerCase).collect(Collectors.toSet());
    }

    public static String jiraAccessToken() {
        return TestConfiguration.getProperty(JIRA_ACCESS_TOKEN, "");
    }

    public static boolean parallel() {
        return TestConfiguration.getBoolean(PARALLEL, false);
    }

    public static boolean useGlobalOpenshiftKafka() {
        return TestConfiguration.getBoolean(TEST_USE_GLOBAL_OPENSHIFT_KAFKA, false);
    }
}

