/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.common.config;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.config.Configuration;
import software.tnb.common.config.TestConfiguration;
import software.tnb.common.utils.StringUtils;

public class OpenshiftConfiguration
extends Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftConfiguration.class);
    public static final String USE_OPENSHIFT = "test.use.openshift";
    public static final String OPENSHIFT_URL = "openshift.url";
    public static final String OPENSHIFT_USERNAME = "openshift.username";
    public static final String OPENSHIFT_PASSWORD = "openshift.password";
    public static final String OPENSHIFT_NAMESPACE = "openshift.namespace";
    public static final String OPENSHIFT_NAMESPACE_DELETE = "openshift.namespace.delete";
    public static final String OPENSHIFT_KUBECONFIG = "openshift.kubeconfig";
    public static final String KUBECONFIG = "kubeconfig";
    public static final String OPENSHIFT_HTTPS_PROXY = "openshift.https.proxy";
    public static final String OPENSHIFT_DEPLOYMENT_LABEL = "openshift.deployment.label";
    private static final String OPENSHIFT_DEPLOY_STRATEGY = "openshift.deploy.strategy";
    private static final String NAMESPACE_PREFIX = "tnb-test-";

    public static boolean isOpenshift() {
        return OpenshiftConfiguration.getBoolean(USE_OPENSHIFT, false);
    }

    public static String openshiftUrl() {
        return OpenshiftConfiguration.getProperty(OPENSHIFT_URL);
    }

    public static String openshiftUsername() {
        return OpenshiftConfiguration.getProperty(OPENSHIFT_USERNAME, "admin");
    }

    public static String openshiftPassword() {
        return OpenshiftConfiguration.getProperty(OPENSHIFT_PASSWORD, "admin");
    }

    public static String openshiftHttpsProxy() {
        return OpenshiftConfiguration.getProperty(OPENSHIFT_HTTPS_PROXY, (String)null);
    }

    @Deprecated
    public static String openshiftNamespace() {
        Object namespace = OpenshiftConfiguration.getProperty(OPENSHIFT_NAMESPACE);
        if (namespace == null) {
            namespace = NAMESPACE_PREFIX + StringUtils.getRandomAlphanumStringOfLength(8);
        } else if (TestConfiguration.parallel()) {
            namespace = (String)namespace + "-" + StringUtils.getRandomAlphanumStringOfLength(8);
        }
        return namespace;
    }

    public static boolean openshiftNamespaceDelete() {
        return OpenshiftConfiguration.getBoolean(OPENSHIFT_NAMESPACE_DELETE, false) || TestConfiguration.parallel() || OpenshiftConfiguration.getProperty(OPENSHIFT_NAMESPACE) == null;
    }

    public static Path openshiftKubeconfig() {
        String kubeconfig = OpenshiftConfiguration.getProperty(OPENSHIFT_KUBECONFIG, OpenshiftConfiguration.getProperty(KUBECONFIG));
        return kubeconfig == null ? null : Paths.get(kubeconfig, new String[0]);
    }

    public static String openshiftDeploymentLabel() {
        return OpenshiftConfiguration.getProperty(OPENSHIFT_DEPLOYMENT_LABEL, "app");
    }

    public static String getDeployStrategy() {
        return OpenshiftConfiguration.getProperty(OPENSHIFT_DEPLOY_STRATEGY, "jkube");
    }
}

