/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.telegram.service;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.deployment.WithDockerImage;
import software.tnb.common.service.Service;
import software.tnb.telegram.account.TelegramAccount;
import software.tnb.telegram.resource.local.LocalTelegram;
import software.tnb.telegram.validation.TelegramValidation;

public abstract class Telegram
implements Service,
WithDockerImage {
    private static final Logger LOG = LoggerFactory.getLogger(LocalTelegram.class);
    private TelegramAccount account;
    private TelegramValidation validation;

    public String defaultImage() {
        return "quay.io/fuse_qe/telegram-client:latest";
    }

    public TelegramAccount account() {
        if (this.account == null) {
            LOG.debug("Creating new Telegram account");
            this.account = (TelegramAccount)AccountFactory.create(TelegramAccount.class);
        }
        return this.account;
    }

    public abstract String execInContainer(String ... var1);

    public TelegramValidation validation() {
        if (this.validation == null) {
            this.validation = new TelegramValidation(this);
        }
        return this.validation;
    }

    public Map<String, String> getEnv() {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("TELEGRAM_DC_ID", this.account().getDcId());
        env.put("TELEGRAM_DC_IP", this.account().getDcIp());
        env.put("TELEGRAM_API_ID", this.account().getAppId());
        env.put("TELEGRAM_API_HASH", this.account().getAppHash());
        env.put("TELEGRAM_SESSION", this.account().getSessionString());
        env.put("TELEGRAM_USERNAME", this.account().getUsername());
        return env;
    }
}

