/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.telegram.resource.openshift;

import com.google.auto.service.AutoService;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParams;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.config.OpenshiftConfiguration;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.deployment.WithName;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.WaitUtils;
import software.tnb.telegram.service.Telegram;

@AutoService(value={Telegram.class})
public class OpenshiftTelegram
extends Telegram
implements OpenshiftDeployable,
WithName {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftTelegram.class);

    public void undeploy() {
        LOG.info("Undeploying Telegram client");
        ((DeployableScalableResource)OpenshiftClient.get().deploymentConfigs().withName(this.name())).delete();
        WaitUtils.waitFor(() -> this.servicePod() == null, (String)"Waiting until the pod is removed");
        ((FilterWatchListDeletable)OpenshiftClient.get().imageStreams().withLabel(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).delete();
    }

    public void openResources() {
    }

    public void closeResources() {
    }

    public void create() {
        LOG.info("Deploying Telegram client");
        ImageStream imageStream = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamSpecFluent.TagsNested)((ImageStreamSpecFluent.TagsNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(this.name())).endMetadata()).withNewSpec().addNewTag().withName("latest")).withFrom(((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind("DockerImage")).withName(this.image())).build())).endTag()).endSpec()).build();
        OpenshiftClient.get().imageStreams().createOrReplace((Object[])new ImageStream[]{imageStream});
        LOG.debug("Creating deployment {}", (Object)this.name());
        OpenshiftClient.get().deploymentConfigs().createOrReplace((Object[])new DeploymentConfig[]{((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().editOrNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).withReplicas(Integer.valueOf(1))).editOrNewTemplate().editOrNewMetadata().addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addNewContainer().withName(this.name())).withImagePullPolicy("IfNotPresent")).addAllToEnv((Collection)this.getEnv().entrySet().stream().map(e -> new EnvVar((String)e.getKey(), (String)e.getValue(), null)).collect(Collectors.toList()))).endContainer()).endSpec()).endTemplate()).addNewTrigger().withType("ConfigChange")).endTrigger()).addNewTrigger().withType("ImageChange")).withImageChangeParams(new DeploymentTriggerImageChangeParams(Boolean.valueOf(true), Arrays.asList(this.name()), ((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind("ImageStreamTag")).withName(this.name() + ":latest")).build(), null))).endTrigger()).endSpec()).build()});
    }

    public boolean isDeployed() {
        DeploymentConfig dc = (DeploymentConfig)((DeployableScalableResource)OpenshiftClient.get().deploymentConfigs().withName(this.name())).get();
        return dc != null && !dc.isMarkedForDeletion();
    }

    public Predicate<Pod> podSelector() {
        return super.podSelector();
    }

    @Override
    public String execInContainer(String ... commands) {
        try {
            return new String(((ExecWatch)((TtyExecErrorable)this.servicePod().redirectingOutput()).exec((Object[])commands)).getOutput().readAllBytes());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read command output: " + e);
        }
    }

    public String name() {
        return "telegram-client";
    }
}

