/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.telegram.validation;

import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.telegram.service.Telegram;

public class TelegramValidation {
    private final Telegram client;
    private static final Logger LOG = LoggerFactory.getLogger(TelegramValidation.class);

    public TelegramValidation(Telegram client) {
        this.client = client;
    }

    public void sendMessage(String text) {
        LOG.debug("Send message " + text + " from telegram-client ");
        try {
            this.client.execInContainer("python3", "/app/send_message.py", text);
        }
        catch (Exception e) {
            Assertions.fail((String)"Failed to send message", (Throwable)e);
        }
    }

    public List<String> getLastNMessages(int n) {
        List<String> messages;
        LOG.debug("Get last " + n + " messages: ");
        try {
            String messagesInStr = this.client.execInContainer("python3", "/app/get_messages.py", "" + n);
            LOG.debug(messagesInStr);
            messages = Arrays.asList(messagesInStr.split("\n"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get messages", e);
        }
        return messages;
    }
}

