/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.telegram.resource.openshift;

import com.google.auto.service.AutoService;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShiftWaiters;
import cz.xtf.core.openshift.helpers.ResourceFunctions;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentTriggerImageChangeParams;
import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;
import io.fabric8.openshift.api.model.ImageStreamFluent;
import io.fabric8.openshift.api.model.ImageStreamSpecFluent;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteBuilder;
import io.fabric8.openshift.api.model.RouteFluent;
import io.fabric8.openshift.api.model.RoutePortBuilder;
import io.fabric8.openshift.api.model.RouteSpecBuilder;
import io.fabric8.openshift.api.model.RouteTargetReferenceBuilder;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.config.OpenshiftConfiguration;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.deployment.WithName;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.telegram.service.TelegramBotApi;

@AutoService(value={TelegramBotApi.class})
public class OpenshiftTelegramBotAPI
extends TelegramBotApi
implements OpenshiftDeployable,
WithName {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftTelegramBotAPI.class);

    public void undeploy() {
        LOG.info("Undeploying Telegram Bot API");
        LOG.debug("Deleting route");
        ((FilterWatchListDeletable)OpenshiftClient.get().routes().withLabel(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).delete();
        LOG.debug("Deleting service");
        ((FilterWatchListDeletable)OpenshiftClient.get().services().withLabel(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).delete();
        LOG.debug("Deleting deploymentconfig {}", (Object)this.name());
        ((DeployableScalableResource)OpenshiftClient.get().deploymentConfigs().withName(this.name())).delete();
        OpenShiftWaiters.get((OpenShift)OpenshiftClient.get(), () -> false).areNoPodsPresent(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name()).timeout(120000L).waitFor();
        LOG.debug("Deleting image stream");
        ((FilterWatchListDeletable)OpenshiftClient.get().imageStreams().withLabel(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).delete();
    }

    public void openResources() {
    }

    public void closeResources() {
    }

    public void create() {
        LOG.info("Deploying Telegram Bot API");
        Map<String, Integer> ports = Map.of(this.name(), this.getPort());
        List containerPorts = ports.entrySet().stream().map(e -> ((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName((String)e.getKey())).withContainerPort((Integer)e.getValue())).withProtocol("TCP")).build()).collect(Collectors.toList());
        ImageStream imageStream = ((ImageStreamBuilder)((ImageStreamFluent.SpecNested)((ImageStreamSpecFluent.TagsNested)((ImageStreamSpecFluent.TagsNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(this.name())).endMetadata()).withNewSpec().addNewTag().withName("latest")).withFrom(((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind("DockerImage")).withName(this.image())).build())).endTag()).endSpec()).build();
        OpenshiftClient.get().imageStreams().createOrReplace((Object[])new ImageStream[]{imageStream});
        LOG.debug("Creating deploymentconfig {}", (Object)this.name());
        OpenshiftClient.get().deploymentConfigs().createOrReplace((Object[])new DeploymentConfig[]{((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().editOrNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).withReplicas(Integer.valueOf(1))).editOrNewTemplate().editOrNewMetadata().addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addNewContainer().withName(this.name())).withArgs(this.startupParams())).withImagePullPolicy("IfNotPresent")).addAllToPorts(containerPorts)).addAllToEnv((Collection)this.getEnv().entrySet().stream().map(e -> new EnvVar((String)e.getKey(), (String)e.getValue(), null)).collect(Collectors.toList()))).withLivenessProbe(((ProbeBuilder)((ProbeBuilder)((ProbeFluent.TcpSocketNested)new ProbeBuilder().editOrNewTcpSocket().withPort(new IntOrString(Integer.valueOf(this.getPort())))).endTcpSocket()).withInitialDelaySeconds(Integer.valueOf(10))).build())).withReadinessProbe(((ProbeBuilder)((ProbeBuilder)((ProbeFluent.TcpSocketNested)new ProbeBuilder().editOrNewTcpSocket().withPort(new IntOrString(Integer.valueOf(this.getPort())))).endTcpSocket()).withInitialDelaySeconds(Integer.valueOf(10))).build())).endContainer()).endSpec()).endTemplate()).addNewTrigger().withType("ConfigChange")).endTrigger()).addNewTrigger().withType("ImageChange")).withImageChangeParams(new DeploymentTriggerImageChangeParams(Boolean.valueOf(true), Arrays.asList(this.name()), ((ObjectReferenceBuilder)((ObjectReferenceBuilder)new ObjectReferenceBuilder().withKind("ImageStreamTag")).withName(this.name() + ":latest")).build(), null))).endTrigger()).endSpec()).build()});
        ports.forEach((key, value) -> {
            ServiceSpecBuilder serviceSpecBuilder = (ServiceSpecBuilder)new ServiceSpecBuilder().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name());
            serviceSpecBuilder.addToPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(key)).withPort(value)).withTargetPort(new IntOrString(value))).build()});
            LOG.debug("Creating service {}", key);
            OpenshiftClient.get().services().createOrReplace((Object[])new Service[]{((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().editOrNewMetadata().withName(key)).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpecLike(serviceSpecBuilder.build()).endSpec()).build()});
            LOG.debug("Creating route {}", key);
            OpenshiftClient.get().routes().createOrReplace((Object[])new Route[]{((RouteBuilder)((RouteBuilder)((RouteFluent.MetadataNested)((RouteFluent.MetadataNested)new RouteBuilder().editOrNewMetadata().withName(key)).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpecLike(((RouteSpecBuilder)((RouteSpecBuilder)new RouteSpecBuilder().withTo(((RouteTargetReferenceBuilder)((RouteTargetReferenceBuilder)new RouteTargetReferenceBuilder().withName(key)).withKind("Service")).build())).withPort(((RoutePortBuilder)new RoutePortBuilder().withTargetPort(new IntOrString(value))).build())).build()).endSpec()).build()});
        });
    }

    public boolean isReady() {
        List pods = OpenshiftClient.get().getLabeledPods(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name());
        if (((Boolean)ResourceFunctions.areExactlyNPodsReady((int)1).apply(pods)).booleanValue()) {
            return OpenshiftClient.get().getLogs((Pod)pods.get(0)).contains("Create tcp listener [address:0.0.0.0][port:" + this.getPort() + "]");
        }
        return false;
    }

    public boolean isDeployed() {
        return OpenshiftClient.get().getLabeledPods(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name()).size() != 0;
    }

    public String externalHostname() {
        return ((Service)((ServiceList)((FilterWatchListDeletable)OpenshiftClient.get().services().withLabel(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).list()).getItems().stream().findFirst().orElseThrow(() -> new RuntimeException("unable to find service for " + this.name()))).getMetadata().getName();
    }

    @Override
    protected String getWorkingDir() {
        return "/tmp";
    }

    @Override
    protected String getUploadDir() {
        return this.getWorkingDir();
    }

    @Override
    public String getLogs() {
        return ((PodResource)OpenshiftClient.get().pods().withName(OpenshiftClient.get().getAnyPod(this.name()).getMetadata().getName())).getLog();
    }

    public String name() {
        return "telegram-api";
    }
}

