/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.telegram.resource.local;

import com.google.auto.service.AutoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.Deployable;
import software.tnb.telegram.resource.local.TelegramBotAPIContainer;
import software.tnb.telegram.service.TelegramBotApi;

@AutoService(value={TelegramBotApi.class})
public class LocalTelegramBotAPI
extends TelegramBotApi
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalTelegramBotAPI.class);
    private TelegramBotAPIContainer container;

    public String externalHostname() {
        return "localhost";
    }

    @Override
    protected String getWorkingDir() {
        return "/home/telegram-bot-api/telegram/working";
    }

    @Override
    protected String getUploadDir() {
        return "/home/telegram-bot-api/telegram/temp-files";
    }

    @Override
    public String getLogs() {
        return this.container.getLogs();
    }

    public void deploy() {
        LOG.debug("Starting Telegram Bot API container");
        this.container = new TelegramBotAPIContainer(this.image(), this.getEnv(), this.startupParams(), this.getPort());
        this.container.start();
    }

    public void undeploy() {
        this.container.stop();
    }

    public void openResources() {
    }

    public void closeResources() {
    }
}

