/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.telegram.resource.local;

import com.google.auto.service.AutoService;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.Deployable;
import software.tnb.telegram.resource.local.TelegramClientContainer;
import software.tnb.telegram.service.Telegram;

@AutoService(value={Telegram.class})
public class LocalTelegram
extends Telegram
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalTelegram.class);
    private TelegramClientContainer container;

    @Override
    public String execInContainer(String ... commands) {
        try {
            return this.container.execInContainer(commands).getStdout();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void deploy() {
        LOG.debug("Starting Telegram client container");
        this.container = new TelegramClientContainer(this.image(), this.getEnv());
        this.container.start();
    }

    public void undeploy() {
        this.container.stop();
    }

    public void openResources() {
    }

    public void closeResources() {
    }
}

