/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.tekton.validation;

import io.fabric8.knative.internal.pkg.apis.Condition;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.tekton.client.TektonClient;
import io.fabric8.tekton.pipeline.v1beta1.Pipeline;
import io.fabric8.tekton.pipeline.v1beta1.PipelineList;
import io.fabric8.tekton.pipeline.v1beta1.PipelineRun;
import io.fabric8.tekton.pipeline.v1beta1.PipelineRunList;
import io.fabric8.tekton.pipeline.v1beta1.Task;
import io.fabric8.tekton.pipeline.v1beta1.TaskList;
import io.fabric8.tekton.pipeline.v1beta1.TaskRun;
import io.fabric8.tekton.pipeline.v1beta1.TaskRunList;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.WaitUtils;
import software.tnb.common.validation.Validation;

public class TektonValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(TektonValidation.class);
    private final TektonClient client;

    public TektonValidation(TektonClient client) {
        this.client = client;
    }

    public Task createTektonTask(Task task) {
        LOG.info("Creating Tekton task " + task.getMetadata().getName());
        return (Task)((NonNamespaceOperation)this.client.v1beta1().tasks().inNamespace(OpenshiftClient.get().getNamespace())).createOrReplace((Object[])new Task[]{task});
    }

    public Task createTektonTask(InputStream isTask) {
        return this.createTektonTask((Task)((Resource)this.client.v1beta1().tasks().load(isTask)).get());
    }

    public Pipeline createTektonPipeline(Pipeline pipeline) {
        LOG.info("Creating Tekton pipeline " + pipeline.getMetadata().getName());
        return (Pipeline)((NonNamespaceOperation)this.client.v1beta1().pipelines().inNamespace(OpenshiftClient.get().getNamespace())).createOrReplace((Object[])new Pipeline[]{pipeline});
    }

    public Pipeline createTektonPipeline(InputStream isPipeline) {
        return this.createTektonPipeline((Pipeline)((Resource)this.client.v1beta1().pipelines().load(isPipeline)).get());
    }

    public PipelineRun createTektonPipelineRun(PipelineRun pipelineRun) {
        LOG.info("Creating Tekton PipelineRun " + pipelineRun.getMetadata().getName());
        return (PipelineRun)((NonNamespaceOperation)this.client.v1beta1().pipelineRuns().inNamespace(OpenshiftClient.get().getNamespace())).createOrReplace((Object[])new PipelineRun[]{pipelineRun});
    }

    public PipelineRun createTektonPipelineRun(InputStream isPipelineRun) {
        return this.createTektonPipelineRun((PipelineRun)((Resource)this.client.v1beta1().pipelineRuns().load(isPipelineRun)).get());
    }

    public List<Task> getAllTasks() {
        LOG.info("Getting all Tekton tasks");
        return ((TaskList)((NonNamespaceOperation)this.client.v1beta1().tasks().inNamespace(OpenshiftClient.get().getNamespace())).list()).getItems();
    }

    public List<Pipeline> getAllPipelines() {
        LOG.info("Getting all Tekton pipelines");
        return ((PipelineList)((NonNamespaceOperation)this.client.v1beta1().pipelines().inNamespace(OpenshiftClient.get().getNamespace())).list()).getItems();
    }

    public List<PipelineRun> getAllPipelineRuns() {
        LOG.info("Getting all Tekton PipelineRuns");
        return ((PipelineRunList)((NonNamespaceOperation)this.client.v1beta1().pipelineRuns().inNamespace(OpenshiftClient.get().getNamespace())).list()).getItems();
    }

    public List<TaskRun> getAllTaskRuns() {
        LOG.info("Getting all Tekton TaskRuns");
        return ((TaskRunList)((NonNamespaceOperation)this.client.v1beta1().taskRuns().inNamespace(OpenshiftClient.get().getNamespace())).list()).getItems();
    }

    public String getTaskRunLog(PipelineRun pipelineRun, Task task) {
        LOG.info("Getting TaskRun log for task: " + task.getMetadata().getName());
        List taskRuns = ((TaskRunList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.v1beta1().taskRuns().inNamespace(OpenshiftClient.get().getNamespace())).withLabel("tekton.dev/task", task.getMetadata().getName())).list()).getItems();
        TaskRun taskrun = taskRuns.stream().filter(taskRun -> ((OwnerReference)taskRun.getMetadata().getOwnerReferences().get(0)).getName().equals(pipelineRun.getMetadata().getName())).findFirst().get();
        return OpenshiftClient.get().getLogs(OpenshiftClient.get().getPod(taskrun.getMetadata().getName() + "-pod"));
    }

    public void waitForTaskRunPodsExecuted(Task task) {
        LOG.info("Waiting for TaskRun pod with name " + task.getMetadata().getName() + " to be executed");
        WaitUtils.waitFor(() -> {
            Optional<TaskRun> taskRun = this.getAllTaskRuns().stream().filter(tr -> tr.getStatus().getPodName().contains(task.getMetadata().getName())).findFirst();
            if (taskRun.isEmpty()) {
                return false;
            }
            Pod pod = (Pod)((PodResource)OpenshiftClient.get().pods().withName(taskRun.get().getStatus().getPodName())).get();
            if (pod != null) {
                return pod.getStatus().getPhase().equals("Succeeded");
            }
            return false;
        }, (String)"TaskRun pod is not in Succeeded state");
    }

    public Boolean pipelineRunIsExecuted(PipelineRun pipelineRun) {
        LOG.info("Checking that PipelineRun " + pipelineRun.getMetadata().getName() + " is executed successfully");
        Optional<PipelineRun> pipelineRunOptional = this.getAllPipelineRuns().stream().filter(p -> Objects.equals(p.getMetadata().getName(), pipelineRun.getMetadata().getName())).findFirst();
        return pipelineRunOptional.isPresent() && "Succeeded".equals(((Condition)pipelineRunOptional.get().getStatus().getConditions().get(0)).getReason());
    }
}

