/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.tekton.service;

import com.google.auto.service.AutoService;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.tekton.client.TektonClient;
import java.io.IOException;
import java.util.List;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.account.NoAccount;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.deployment.WithOperatorHub;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.service.Service;
import software.tnb.common.utils.WaitUtils;
import software.tnb.tekton.validation.TektonValidation;

@AutoService(value={Tekton.class})
public class Tekton
extends Service<NoAccount, TektonClient, TektonValidation>
implements OpenshiftDeployable,
WithOperatorHub {
    private static final Logger LOG = LoggerFactory.getLogger(Tekton.class);

    protected TektonClient client() {
        if (OpenshiftClient.get().isAdaptable(TektonClient.class).booleanValue()) {
            return (TektonClient)OpenshiftClient.get().adapt(TektonClient.class);
        }
        throw new IllegalArgumentException("Unable to adapt OpenshiftClient to TektonClient");
    }

    public TektonValidation validation() {
        if (this.validation == null) {
            this.validation = new TektonValidation(this.client());
        }
        return (TektonValidation)this.validation;
    }

    public void create() {
        LOG.debug("Creating Tekton operator");
        this.createSubscription();
    }

    public void undeploy() {
        LOG.debug("Undeploy Tekton operator");
        CustomResourceDefinitionContext crd = new CustomResourceDefinitionContext.Builder().withName("tektonconfigs.operator.tekton.dev").withGroup("operator.tekton.dev").withVersion("v1alpha1").withPlural("tektonconfigs").withScope("Cluster").build();
        try {
            OpenshiftClient.get().customResource(crd).delete("openshift-pipelines", "config", true);
            WaitUtils.waitFor(() -> ((Resource)OpenshiftClient.get().namespaces().withName("openshift-pipelines")).get() == null, (String)"Waiting until the openshift-pipelines namespace is removed");
            this.deleteSubscription(() -> OpenshiftClient.get().getLabeledPods("name", "openshift-pipelines-operator").stream().noneMatch(p -> p.getMetadata().getName().contains("openshift-pipelines-operator")));
        }
        catch (IOException e) {
            LOG.error("Error on Tekton deletetion", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void openResources() {
    }

    public void closeResources() {
    }

    public boolean isReady() {
        if (((Resource)OpenshiftClient.get().namespaces().withName("openshift-pipelines")).isReady()) {
            List deploys = ((DeploymentList)((FilterWatchListDeletable)((NonNamespaceOperation)OpenshiftClient.get().apps().deployments().inNamespace("openshift-pipelines")).withLabel("operator.tekton.dev/operand-name")).list()).getItems();
            return deploys.size() >= 12 && deploys.stream().allMatch(d -> d.getStatus() != null) && deploys.stream().allMatch(d -> Integer.valueOf(1).equals(d.getStatus().getReadyReplicas()));
        }
        return false;
    }

    public boolean isDeployed() {
        return !((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)OpenshiftClient.get().pods().inNamespace(this.targetNamespace())).withLabel("name", "tekton-operator-webhook")).list()).getItems().isEmpty() && !((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)OpenshiftClient.get().pods().inNamespace(this.targetNamespace())).withLabel("name", "openshift-pipelines-operator")).list()).getItems().isEmpty();
    }

    public Predicate<Pod> podSelector() {
        return null;
    }

    public String targetNamespace() {
        return "openshift-operators";
    }

    public String operatorName() {
        return "openshift-pipelines-operator-rh";
    }

    public String operatorChannel() {
        return "latest";
    }

    public boolean clusterWide() {
        return true;
    }
}

