/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.slack.validation;

import com.slack.api.Slack;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.SlackApiTextResponse;
import com.slack.api.methods.request.chat.ChatPostMessageRequest;
import com.slack.api.methods.request.conversations.ConversationsHistoryRequest;
import com.slack.api.methods.request.conversations.ConversationsListRequest;
import com.slack.api.methods.response.chat.ChatPostMessageResponse;
import com.slack.api.methods.response.conversations.ConversationsListResponse;
import com.slack.api.model.ConversationType;
import com.slack.api.model.Message;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.utils.WaitUtils;
import software.tnb.common.validation.Validation;
import software.tnb.slack.account.SlackAccount;
import software.tnb.slack.validation.MessageRequestConfig;
import software.tnb.slack.validation.util.ThrowingFunction;

public class SlackValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(SlackValidation.class);
    private final Slack client;
    private final SlackAccount account;

    public SlackValidation(Slack client, SlackAccount account) {
        this.client = client;
        this.account = account;
    }

    public void sendMessageToChannelId(String text, String conversationId) {
        LOG.debug("Sending message {} to Slack conversation with id {}", (Object)text, (Object)conversationId);
        ChatPostMessageResponse chatPostMessageResponse = this.invoke(c -> c.methods().chatPostMessage(ChatPostMessageRequest.builder().token(this.account.token()).channel(conversationId).text(text).build()));
        if (!chatPostMessageResponse.isOk()) {
            LOG.debug("Send message response: " + chatPostMessageResponse);
        }
    }

    public void sendMessageToChannelName(String text, String channelName) {
        String channelId = this.getChannelId(channelName);
        this.sendMessageToChannelId(text, channelId);
    }

    public List<String> getMessages(MessageRequestConfig messageRequestConfig) {
        return this.invoke(c -> this.client.methods().conversationsHistory(this.buildConversationRequest(messageRequestConfig))).getMessages().stream().map(Message::getText).collect(Collectors.toList());
    }

    public List<String> getMessagesFromChannelId(String conversationId) {
        return this.invoke(c -> this.client.methods().conversationsHistory(ConversationsHistoryRequest.builder().token(this.account.token()).channel(conversationId).build())).getMessages().stream().map(Message::getText).collect(Collectors.toList());
    }

    public List<String> getMessagesFromChannelName(String channelName) {
        ConversationsListResponse conversationsList = this.invoke(c -> c.methods().conversationsList(ConversationsListRequest.builder().token(this.account.token()).types(List.of(ConversationType.IM, ConversationType.MPIM, ConversationType.PRIVATE_CHANNEL, ConversationType.PUBLIC_CHANNEL)).build()));
        String channelId = conversationsList.getChannels().stream().filter(c -> c.getName().equals(channelName)).findFirst().get().getId();
        return this.getMessagesFromChannelId(channelId);
    }

    private String getChannelId(String channelName) {
        ConversationsListResponse conversationsList = this.invoke(c -> c.methods().conversationsList(ConversationsListRequest.builder().token(this.account.token()).build()));
        return conversationsList.getChannels().stream().filter(c -> c.getName().contains(channelName)).findFirst().get().getId();
    }

    private ConversationsHistoryRequest buildConversationRequest(MessageRequestConfig config) {
        ConversationsHistoryRequest.ConversationsHistoryRequestBuilder builder = config.getBuilder();
        if (config.getChannelName() != null) {
            builder.channel(this.getChannelId(config.getChannelName()));
        }
        return builder.token(this.account.token()).build();
    }

    @NotNull
    private <T extends SlackApiTextResponse> T invoke(ThrowingFunction<Slack, T> consumer) {
        try {
            return (T)((SlackApiTextResponse)consumer.apply(this.client));
        }
        catch (SlackApiException e) {
            if (e.getResponse().code() == 429) {
                String retryAfter = e.getResponse().header("Retry-After");
                if (retryAfter != null) {
                    int wait = Integer.parseInt(retryAfter);
                    LOG.warn("Slack returned HTTP 429 API Limited, will sleep for {} seconds", (Object)wait);
                    WaitUtils.sleep((long)((long)(wait + 1) * 1000L));
                    return this.invoke(consumer);
                }
                Assertions.fail((String)"Got HTTP 429 API Limited, but no Retry-After header was set");
            } else {
                Assertions.fail((String)"Exception from Slack API", (Throwable)e);
            }
        }
        catch (Exception e) {
            Assertions.fail((String)"Unable to invoke Slack API", (Throwable)e);
        }
        return null;
    }
}

