/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.slack.service;

import com.google.auto.service.AutoService;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.service.Service;
import software.tnb.slack.account.SlackAccount;
import software.tnb.slack.validation.SlackValidation;

@AutoService(value={Slack.class})
public class Slack
extends Service<SlackAccount, com.slack.api.Slack, SlackValidation> {
    private static final Logger LOG = LoggerFactory.getLogger(Slack.class);

    protected com.slack.api.Slack client() {
        LOG.debug("Creating new Slack client");
        this.client = com.slack.api.Slack.getInstance();
        return (com.slack.api.Slack)this.client;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        if (this.client != null) {
            LOG.debug("Closing Slack client");
            ((com.slack.api.Slack)this.client).close();
        }
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        LOG.debug("Creating new Slack validation");
        this.validation = new SlackValidation(this.client(), (SlackAccount)this.account());
    }
}

