/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.slack.account;

import java.util.Map;
import software.tnb.common.account.Account;
import software.tnb.common.account.WithId;

public class SlackAccount
implements Account,
WithId {
    private String token;
    private Map<String, ChannelAccount> channels;

    public String credentialsId() {
        return "slack-tnb";
    }

    public String token() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String channelId(String channelName) {
        return this.getChannel(channelName).channelId();
    }

    public String webhookUrl(String channelName) {
        return this.getChannel(channelName).webhookUrl();
    }

    public String channel(String channelName) {
        ChannelAccount account = this.getChannel(channelName);
        return account.name() == null ? channelName : account.name();
    }

    public void setChannels(Map<String, ChannelAccount> channels) {
        this.channels = channels;
    }

    private ChannelAccount getChannel(String channelName) {
        ChannelAccount account = this.channels.get(channelName);
        if (account == null) {
            throw new IllegalArgumentException("Unknown channel " + channelName);
        }
        return account;
    }

    public static class ChannelAccount {
        private String name;
        private String webhook_url;
        private String channel_id;

        public String name() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String webhookUrl() {
            return this.webhook_url;
        }

        public void setWebhook_url(String webhook_url) {
            this.webhook_url = webhook_url;
        }

        public String channelId() {
            return this.channel_id;
        }

        public void setChannel_id(String channel_id) {
            this.channel_id = channel_id;
        }
    }
}

