/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.servicenow.validation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import okhttp3.Credentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.utils.HTTPUtils;
import software.tnb.servicenow.account.ServiceNowAccount;
import software.tnb.servicenow.dto.Incident;
import software.tnb.servicenow.dto.IncidentRecordList;
import software.tnb.servicenow.dto.IncidentSingleResponse;

public class ServiceNowValidation {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceNowValidation.class);
    private ServiceNowAccount account;
    private ObjectMapper om;

    public ServiceNowValidation(ServiceNowAccount account) {
        this.account = account;
        this.om = new ObjectMapper();
        this.om.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
    }

    public List<Incident> getIncidents(int limit) {
        return this.getFilteredIncidents(null, limit);
    }

    public List<Incident> getFilteredIncidents(String filter, int limit) {
        String getUrl = this.account.url() + "?sysparm_limit=" + limit;
        if (filter != null) {
            try {
                getUrl = getUrl + "&sysparm_query=" + URLEncoder.encode(filter, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        HTTPUtils.Response r = HTTPUtils.getInstance().get(getUrl, Map.of("Authorization", Credentials.basic((String)this.account.userName(), (String)this.account.password())));
        return this.parseResponse(r.getBody());
    }

    public void deleteIncident(String incidentId) {
        HTTPUtils.getInstance().delete(String.format("%s/%s", this.account.url(), incidentId), Map.of("Authorization", Credentials.basic((String)this.account.userName(), (String)this.account.password())));
        LOG.debug("Deleted serviceNow incident with id: {} ", (Object)incidentId);
    }

    private List<Incident> parseResponse(String response) {
        ArrayList<Incident> incidents = new ArrayList<Incident>();
        try {
            IncidentRecordList irl = (IncidentRecordList)this.om.readValue(response, IncidentRecordList.class);
            incidents.addAll(irl.getRecords());
            return incidents;
        }
        catch (IOException e) {
            try {
                incidents.add(((IncidentSingleResponse)this.om.readValue(response, IncidentSingleResponse.class)).getRecord());
                return incidents;
            }
            catch (IOException e1) {
                LOG.error("Unable to unmarshall incident response", (Throwable)e);
                return null;
            }
        }
    }
}

