/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.servicenow.service;

import com.google.auto.service.AutoService;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.service.Service;
import software.tnb.servicenow.account.ServiceNowAccount;
import software.tnb.servicenow.validation.ServiceNowValidation;

@AutoService(value={ServiceNow.class})
public class ServiceNow
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceNow.class);
    private ServiceNowAccount account;
    private ServiceNowValidation validation;

    public ServiceNowAccount account() {
        if (this.account == null) {
            this.account = (ServiceNowAccount)AccountFactory.create(ServiceNowAccount.class);
        }
        return this.account;
    }

    public ServiceNowValidation validation() {
        if (this.validation == null) {
            LOG.debug("Creating new ServiceNow validation");
            this.validation = new ServiceNowValidation(this.account());
        }
        return this.validation;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
    }
}

