/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.salesforce.service;

import com.force.api.ApiConfig;
import com.force.api.ForceApi;
import com.google.auto.service.AutoService;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.service.Service;
import software.tnb.common.utils.WaitUtils;
import software.tnb.salesforce.account.SalesforceAccount;
import software.tnb.salesforce.validation.SalesforceValidation;

@AutoService(value={Salesforce.class})
public class Salesforce
implements Service {
    private static final Logger LOG = LoggerFactory.getLogger(Salesforce.class);
    private SalesforceAccount account;
    private ForceApi client;
    private SalesforceValidation validation;

    public SalesforceAccount account() {
        if (this.account == null) {
            this.account = (SalesforceAccount)AccountFactory.create(SalesforceAccount.class);
        }
        return this.account;
    }

    protected ForceApi client() {
        if (this.client == null) {
            WaitUtils.waitFor(() -> {
                try {
                    this.client = new ForceApi(new ApiConfig().setClientId(this.account().clientId()).setClientSecret(this.account().clientSecret()).setUsername(this.account().userName()).setPassword(this.account().password()).setForceURL(this.account().loginUrl()));
                    return true;
                }
                catch (Exception ex) {
                    LOG.error("Unable to connect to salesforce, will retry in 5 minutes", (Throwable)ex);
                    return false;
                }
            }, (int)3, (long)300000L, (String)"Trying to connect to SalesForce");
        }
        return this.client;
    }

    public SalesforceValidation validation() {
        if (this.validation == null) {
            LOG.debug("Creating new Salesforce validation");
            this.validation = new SalesforceValidation(this.client());
        }
        return this.validation;
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
    }
}

