/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.redis.resource.openshift;

import com.google.auto.service.AutoService;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.PortForward;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import java.io.Closeable;
import java.util.function.Predicate;
import software.tnb.common.config.OpenshiftConfiguration;
import software.tnb.common.deployment.ReusableOpenshiftDeployable;
import software.tnb.common.deployment.WithName;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.IOUtils;
import software.tnb.common.utils.NetworkUtils;
import software.tnb.common.utils.WaitUtils;
import software.tnb.redis.service.Redis;

@AutoService(value={Redis.class})
public class OpenshiftRedis
extends Redis
implements ReusableOpenshiftDeployable,
WithName {
    private PortForward portForward;
    private int localPort;

    public void undeploy() {
        ((DeployableScalableResource)OpenshiftClient.get().deploymentConfigs().withName(this.name())).delete();
        ((FilterWatchListDeletable)OpenshiftClient.get().services().withLabel(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).delete();
        WaitUtils.waitFor(() -> this.servicePod() == null, (String)"Waiting until the pod is removed");
    }

    public void openResources() {
        this.localPort = NetworkUtils.getFreePort();
        this.portForward = (PortForward)((ServiceResource)OpenshiftClient.get().services().withName(this.name())).portForward(6379, this.localPort);
        this.client = RedisClient.create((RedisURI)RedisURI.builder().withHost("localhost").withPort(this.localPort).build());
    }

    public void closeResources() {
        if (this.portForward != null && this.portForward.isAlive()) {
            IOUtils.closeQuietly((Closeable)this.portForward);
        }
    }

    public void create() {
        OpenshiftClient.get().deploymentConfigs().createOrReplace((Object[])new DeploymentConfig[]{((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().withNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).withReplicas(Integer.valueOf(1))).editOrNewTemplate().editOrNewMetadata().addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addNewContainer().withName(this.name())).withImage(this.defaultImage())).addNewPort().withContainerPort(Integer.valueOf(6379))).withName(this.name())).endPort()).endContainer()).endSpec()).endTemplate()).addNewTrigger().withType("ConfigChange")).endTrigger()).endSpec()).build()});
        OpenshiftClient.get().services().createOrReplace((Object[])new Service[]{((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().editOrNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).addNewPort().withName(this.name())).withProtocol("TCP")).withPort(Integer.valueOf(6379))).withTargetPort(new IntOrString(Integer.valueOf(6379)))).endPort()).endSpec()).build()});
    }

    public boolean isDeployed() {
        return ((DeploymentList)((FilterWatchListDeletable)OpenshiftClient.get().apps().deployments().withLabel(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).list()).getItems().size() > 0;
    }

    public Predicate<Pod> podSelector() {
        return super.podSelector();
    }

    public void cleanup() {
    }

    public String name() {
        return "redis";
    }

    @Override
    public String host() {
        return this.name();
    }

    @Override
    public int port() {
        return 6379;
    }
}

