/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.redis.resource.local;

import com.google.auto.service.AutoService;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.Deployable;
import software.tnb.redis.resource.local.RedisContainer;
import software.tnb.redis.service.Redis;

@AutoService(value={Redis.class})
public class LocalRedis
extends Redis
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalRedis.class);
    private RedisContainer redisContainer;

    public void deploy() {
        LOG.info("Starting Redis container");
        this.redisContainer = new RedisContainer(this.defaultImage(), 6379);
        this.redisContainer.start();
        LOG.info("Redis container started");
    }

    public void undeploy() {
        if (this.redisContainer != null) {
            LOG.info("Stopping Redis container");
            this.redisContainer.stop();
        }
    }

    @Override
    public String host() {
        return this.redisContainer.getHost();
    }

    @Override
    public int port() {
        return this.redisContainer.getMappedPort(6379);
    }

    public void openResources() {
        this.client = RedisClient.create((RedisURI)RedisURI.builder().withHost(this.host()).withPort(this.port()).build());
    }

    public void closeResources() {
    }
}

