/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.prometheus.metrics.validation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.utils.HTTPUtils;
import software.tnb.common.validation.Validation;
import software.tnb.prometheus.metrics.configuration.PrometheusMetricsConfiguration;
import software.tnb.prometheus.metrics.validation.InstantValue;
import software.tnb.prometheus.metrics.validation.MetricData;

public class PrometheusMetricsValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusMetricsValidation.class);
    private String url;
    private String token;
    private String targetNamespace;
    private HTTPUtils client;

    public PrometheusMetricsValidation(String url, String token, String targetNamespace) {
        this.url = url;
        this.token = token;
        this.targetNamespace = targetNamespace;
        HTTPUtils.OkHttpClientBuilder okHttpClientBuilder = new HTTPUtils.OkHttpClientBuilder();
        okHttpClientBuilder.trustAllSslClient();
        if (PrometheusMetricsConfiguration.isHttpLogEnabled()) {
            okHttpClientBuilder.log();
        }
        this.client = HTTPUtils.getInstance((OkHttpClient)okHttpClientBuilder.build());
    }

    public JsonObject executeQuery(String query, long time) {
        LOG.info("getting metrics until instant in EPOCH seconds: {}", (Object)time);
        HTTPUtils.Response response = this.client.get(this.url + "/api/v1/query?query=" + query + "&time=" + time, Map.of("Authorization", "Bearer " + this.token));
        JsonParser parser = new JsonParser();
        JsonObject json = parser.parse(response.getBody()).getAsJsonObject();
        if (!json.get("status").getAsString().equalsIgnoreCase("success")) {
            throw new IllegalStateException("The metric query failed");
        }
        return json;
    }

    public JsonObject executeQuery(String query) {
        JsonParser parser = new JsonParser();
        HTTPUtils.Response response = this.client.get(this.url + "/api/v1/query?query=" + query, Map.of("Authorization", "Bearer " + this.token));
        JsonObject json = parser.parse(response.getBody()).getAsJsonObject();
        if (!json.get("status").getAsString().equalsIgnoreCase("success")) {
            throw new IllegalStateException("The metric query failed");
        }
        return json;
    }

    public JsonObject executeQueryRange(String query, long start, long end, long step) {
        JsonParser parser = new JsonParser();
        HTTPUtils.Response response = this.client.get(String.format("%s/api/v1/query_range?query=%s&start=%d&end=%d&step=%d", this.url, query, start, end, step), Map.of("Authorization", "Bearer " + this.token));
        JsonObject json = parser.parse(response.getBody()).getAsJsonObject();
        if (!json.get("status").getAsString().equalsIgnoreCase("success")) {
            throw new IllegalStateException("The metric query failed");
        }
        return json;
    }

    public List<InstantValue> executeQuery(PodMetric metric, String podNamePattern, long start, long end, long step) {
        return this.executeQueryRangeSingleMetricWithVector(metric.query, start, end, step, this.targetNamespace, podNamePattern);
    }

    public List<MetricData> executeQuery(OtherPodMetric metric, String podNamePattern, long start, long end) {
        return this.executeQueryToGetMatrix(metric.query, end, List.of("pod", "node"), this.targetNamespace, podNamePattern, end - start);
    }

    public List<InstantValue> executeQuery(Operation operation, PodMetric metric, String podNamePattern, long start, long end, long step) {
        String query = operation.function + "(" + metric.query + ")";
        return this.executeQueryRangeSingleMetricWithVector(query, start, end, step, this.targetNamespace, podNamePattern);
    }

    public List<InstantValue> executeQuery(NodeMetric metric, String nodeName, long start, long end, long step) {
        return this.executeQueryRangeSingleMetricWithVector(metric.query, start, end, step, nodeName);
    }

    public List<InstantValue> executeQueryRangeSingleMetricWithVector(String query, long start, long end, long step, Object ... params) {
        String queryToExecute = String.format(query, params);
        JsonObject json = this.executeQueryRange(queryToExecute, start, end, step);
        JsonArray result = json.get("data").getAsJsonObject().get("result").getAsJsonArray();
        if (result.size() == 0) {
            return Collections.emptyList();
        }
        JsonArray data = result.get(0).getAsJsonObject().get("values").getAsJsonArray();
        Iterator it = data.iterator();
        ArrayList<InstantValue> instantValues = new ArrayList<InstantValue>(data.size());
        while (it.hasNext()) {
            JsonArray jsonValues = (JsonArray)it.next();
            instantValues.add(new InstantValue(jsonValues.get(1).getAsNumber(), jsonValues.get(0).getAsLong()));
        }
        return instantValues;
    }

    public List<MetricData> executeQueryToGetMatrix(String query, long time, List<String> metricPropertiesToExtract, Object ... params) {
        String queryToExecute = String.format(query, params);
        JsonObject json = this.executeQuery(queryToExecute, time);
        JsonArray result = json.get("data").getAsJsonObject().get("result").getAsJsonArray();
        if (result.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<MetricData> metricDataList = new ArrayList<MetricData>(result.size());
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            JsonObject o = ((JsonElement)iterator.next()).getAsJsonObject();
            JsonObject metricJson = o.get("metric").getAsJsonObject();
            HashMap<String, String> metric = new HashMap<String, String>();
            metricPropertiesToExtract.forEach(p -> {
                if (metricJson.has(p)) {
                    metric.put((String)p, metricJson.get(p).getAsString());
                }
            });
            JsonArray values = o.get("values").getAsJsonArray();
            ArrayList<InstantValue> instantValues = new ArrayList<InstantValue>(values.size());
            for (JsonArray instantValueJson : values) {
                InstantValue instantValue = new InstantValue(instantValueJson.get(1).getAsNumber(), instantValueJson.get(0).getAsLong());
                instantValues.add(instantValue);
            }
            metricDataList.add(new MetricData(metric, instantValues));
        }
        return metricDataList;
    }

    public String getUrl() {
        return this.url;
    }

    public static enum NodeMetric {
        MEMORY("node_memory_MemTotal_bytes - node_memory_MemAvailable_bytes{instance=\"%s\"}"),
        CPU("instance:node_cpu:ratio{instance=\"%s\"}");

        String query;

        private NodeMetric(String query) {
            this.query = query;
        }
    }

    public static enum OtherPodMetric {
        POD_INFO("node_namespace_pod:kube_pod_info:{namespace=\"%s\",pod=~\"%s\"}[%ss]");

        String query;

        private OtherPodMetric(String query) {
            this.query = query;
        }
    }

    public static enum PodMetric {
        MEMORY("sum(container_memory_working_set_bytes{namespace=\"%s\",pod=~\"%s\"})"),
        CPU("pod:container_cpu_usage:sum{namespace=\"%s\",pod=~\"%s\"}");

        String query;

        private PodMetric(String query) {
            this.query = query;
        }
    }

    public static enum Operation {
        SUM("sum"),
        AVG("avg");

        String function;

        private Operation(String function) {
            this.function = function;
        }
    }
}

