/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.mongodb.validation;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.validation.Validation;
import software.tnb.db.mongodb.account.MongoDBAccount;

public class MongoDBValidation
implements Validation {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDBValidation.class);
    private final MongoClient client;
    private final MongoDBAccount account;

    public MongoDBValidation(MongoClient client, MongoDBAccount account) {
        this.client = client;
        this.account = account;
    }

    public String createDocument(String collectionName, Document document) {
        LOG.info("Publishing document {} into a collection named {}", (Object)document.toJson(), (Object)collectionName);
        this.client.getDatabase(this.account.database()).getCollection(collectionName).insertOne((Object)document);
        return document.get((Object)"_id").toString();
    }

    public List<String> createDocuments(String collectionName, Document ... documents) {
        ArrayList<String> ids = new ArrayList<String>();
        for (Document document : documents) {
            ids.add(this.createDocument(collectionName, document));
        }
        return ids;
    }

    public List<Document> getDocuments(String collectionName) {
        return this.getDocuments(collectionName, -1);
    }

    public List<Document> getDocuments(String collectionName, int count) {
        return this.getDocuments(this.account.database(), collectionName, count);
    }

    private List<Document> getDocuments(String dbName, String collectionName, int count) {
        LOG.debug("Getting documents in MongoDB database {} collection {}", (Object)dbName, (Object)collectionName);
        MongoCollection collection = this.client.getDatabase(dbName).getCollection(collectionName);
        if (count == -1) {
            return StreamSupport.stream(collection.find().spliterator(), false).collect(Collectors.toList());
        }
        return StreamSupport.stream(collection.find().spliterator(), false).limit(count).collect(Collectors.toList());
    }

    public UpdateResult replaceDocument(String collectionName, Bson filter, Document document) {
        LOG.info("Replacing at most one document specified by filter {} with new document {} in a collection named {}", new Object[]{filter, document.toJson(), collectionName});
        return this.client.getDatabase(this.account.database()).getCollection(collectionName).replaceOne(filter, (Object)document);
    }

    public UpdateResult updateDocument(String collectionName, Bson filter, Bson document) {
        LOG.info("Updating at most one document specified by filter {} with new document {} in a collection named {}", new Object[]{filter, document.toBsonDocument().toJson(), collectionName});
        return this.client.getDatabase(this.account.database()).getCollection(collectionName).updateOne(filter, document);
    }

    public DeleteResult deleteDocument(String collectionName, Bson filter) {
        LOG.info("Deleting at most one document by filter {} in a collection named {}", (Object)filter, (Object)collectionName);
        return this.client.getDatabase(this.account.database()).getCollection(collectionName).deleteOne(filter);
    }

    public void createCollection(String collectionName) {
        CreateCollectionOptions options = new CreateCollectionOptions();
        options.capped(true);
        options.sizeInBytes(0x100000L);
        this.client.getDatabase(this.account.database()).createCollection(collectionName, options);
    }

    public void deleteCollection(String collectionName) {
        this.client.getDatabase(this.account.database()).getCollection(collectionName).drop();
    }

    public void copyAllDocuments(String sourceCollection, String destCollection) {
        this.client.getDatabase(this.account.database()).getCollection(destCollection).insertMany(this.getDocuments(sourceCollection));
    }

    public void cloneDatabase(String sourceDatabase) {
        this.client.getDatabase(sourceDatabase).listCollectionNames().forEach(c -> this.copyCollectionFromDatabase(sourceDatabase, (String)c));
    }

    public void copyCollectionFromDatabase(String sourceDatabase, String collectionName) {
        CreateCollectionOptions options = new CreateCollectionOptions();
        options.capped(true);
        options.sizeInBytes(0x100000L);
        this.client.getDatabase(this.account.database()).createCollection(collectionName, options);
        this.client.getDatabase(this.account.database()).getCollection(collectionName).insertMany(this.getDocuments(sourceDatabase, collectionName, -1));
    }

    public void dropDatabase(String databaseName) {
        this.client.getDatabase(databaseName).drop();
    }
}

