/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.mongodb.service;

import com.mongodb.client.MongoClient;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.WithDockerImage;
import software.tnb.common.service.Service;
import software.tnb.db.mongodb.account.MongoDBAccount;
import software.tnb.db.mongodb.validation.MongoDBValidation;

public abstract class MongoDB
extends Service<MongoDBAccount, MongoClient, MongoDBValidation>
implements WithDockerImage {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDB.class);
    public static final int DEFAULT_PORT = 27017;

    public MongoDBValidation validation() {
        if (this.validation == null) {
            LOG.debug("Creating new MongoDB validation");
            this.validation = new MongoDBValidation((MongoClient)this.client(), (MongoDBAccount)this.account());
        }
        return (MongoDBValidation)this.validation;
    }

    public Map<String, String> containerEnvironment() {
        return Map.of("MONGODB_USERNAME", ((MongoDBAccount)this.account()).username(), "MONGODB_PASSWORD", ((MongoDBAccount)this.account()).password(), "MONGODB_DATABASE", ((MongoDBAccount)this.account()).database(), "MONGODB_REPLICA_SET_NAME", ((MongoDBAccount)this.account()).replicaSetName(), "MONGODB_REPLICA_SET_MODE", ((MongoDBAccount)this.account()).replicaSetMode(), "MONGODB_REPLICA_SET_KEY", ((MongoDBAccount)this.account()).replicaSetKey(), "MONGODB_ROOT_PASSWORD", ((MongoDBAccount)this.account()).rootPassword());
    }

    public abstract String replicaSetUrl();

    public int port() {
        return 27017;
    }

    public String defaultImage() {
        return "quay.io/fuse_qe/mongodb:4.4.5";
    }

    public abstract String hostname();
}

