/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.mongodb.resource.openshift;

import com.google.auto.service.AutoService;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.PortForward;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.client.dsl.DeployableScalableResource;
import java.io.Closeable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.config.OpenshiftConfiguration;
import software.tnb.common.deployment.ReusableOpenshiftDeployable;
import software.tnb.common.deployment.WithExternalHostname;
import software.tnb.common.deployment.WithInClusterHostname;
import software.tnb.common.deployment.WithName;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.IOUtils;
import software.tnb.common.utils.NetworkUtils;
import software.tnb.common.utils.WaitUtils;
import software.tnb.db.mongodb.account.MongoDBAccount;
import software.tnb.db.mongodb.service.MongoDB;

@AutoService(value={MongoDB.class})
public class OpenshiftMongoDB
extends MongoDB
implements ReusableOpenshiftDeployable,
WithName,
WithInClusterHostname,
WithExternalHostname {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftMongoDB.class);
    private PortForward portForward;
    private int localPort;

    public void create() {
        LOG.info("Deploying OpenShift MongoDB");
        LinkedList<ContainerPort> ports = new LinkedList<ContainerPort>();
        ports.add(((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("mongodb")).withContainerPort(Integer.valueOf(this.port()))).withProtocol("TCP")).build());
        LOG.debug("Creating deploymentconfig {}", (Object)this.name());
        OpenshiftClient.get().deploymentConfigs().createOrReplace((Object[])new DeploymentConfig[]{((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((DeploymentConfigSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().editOrNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).withReplicas(Integer.valueOf(1))).editOrNewTemplate().editOrNewMetadata().addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpec().addNewContainer().withName(this.name())).withImage(this.image())).addAllToPorts(ports)).addAllToEnv((Collection)this.containerEnvironment().entrySet().stream().map(e -> new EnvVar((String)e.getKey(), (String)e.getValue(), null)).collect(Collectors.toList()))).endContainer()).endSpec()).endTemplate()).addNewTrigger().withType("ConfigChange")).endTrigger()).endSpec()).build()});
        ServiceSpecBuilder serviceSpecBuilder = (ServiceSpecBuilder)new ServiceSpecBuilder().addToSelector(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name());
        serviceSpecBuilder.addToPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(this.name())).withPort(Integer.valueOf(this.port()))).withTargetPort(new IntOrString(Integer.valueOf(this.port())))).build()});
        LOG.debug("Creating service {}", (Object)this.name());
        OpenshiftClient.get().services().createOrReplace((Object[])new Service[]{((ServiceBuilder)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().editOrNewMetadata().withName(this.name())).addToLabels(OpenshiftConfiguration.openshiftDeploymentLabel(), this.name())).endMetadata()).editOrNewSpecLike(serviceSpecBuilder.build()).endSpec()).build()});
    }

    public void undeploy() {
        LOG.info("Undeploying OpenShift MongoDB");
        LOG.debug("Deleting service {}", (Object)this.name());
        ((ServiceResource)OpenshiftClient.get().services().withName(this.name())).delete();
        LOG.debug("Deleting deploymentconfig {}", (Object)this.name());
        ((DeployableScalableResource)OpenshiftClient.get().deploymentConfigs().withName(this.name())).delete();
        WaitUtils.waitFor(() -> this.servicePod() == null, (String)"Waiting until the pod is removed");
    }

    public void openResources() {
        this.localPort = NetworkUtils.getFreePort();
        LOG.debug("Creating port-forward to {} for port {}", (Object)this.name(), (Object)this.port());
        this.portForward = (PortForward)((ServiceResource)OpenshiftClient.get().services().withName(this.name())).portForward(this.port(), this.localPort);
        LOG.debug("Creating new MongoClient instance");
        this.client = MongoClients.create((String)this.replicaSetUrl().replace("@" + this.hostname(), "@" + this.externalHostname()).replace("27017", "" + this.localPort));
    }

    public boolean isReady() {
        PodResource pod = this.servicePod();
        return pod != null && pod.isReady() && OpenshiftClient.get().getLogs((Pod)pod.get()).contains("Transition to primary complete; database writes are now permitted");
    }

    public boolean isDeployed() {
        Deployment deployment = (Deployment)((RollableScalableResource)OpenshiftClient.get().apps().deployments().withName(this.name())).get();
        return deployment != null && !deployment.isMarkedForDeletion();
    }

    public Predicate<Pod> podSelector() {
        return super.podSelector();
    }

    public String name() {
        return "mongodb";
    }

    @Override
    public String replicaSetUrl() {
        return String.format("mongodb://%s:%s@%s:%d/%s", ((MongoDBAccount)this.account()).username(), ((MongoDBAccount)this.account()).password(), this.hostname(), 27017, ((MongoDBAccount)this.account()).database());
    }

    @Override
    public String hostname() {
        return this.inClusterHostname();
    }

    public void cleanup() {
        LOG.info("Cleaning MongoDB database");
        MongoDatabase db = ((MongoClient)this.client()).getDatabase(((MongoDBAccount)this.account()).database());
        for (String collection : db.listCollectionNames()) {
            LOG.debug("Dropping collection {}", (Object)collection);
            db.getCollection(collection).drop();
        }
    }

    public void closeResources() {
        if (this.client != null) {
            LOG.debug("Closing MongoDB client");
            ((MongoClient)this.client).close();
        }
        if (this.portForward != null && this.portForward.isAlive()) {
            LOG.debug("Closing port-forward");
            IOUtils.closeQuietly((Closeable)this.portForward);
        }
        NetworkUtils.releasePort((int)this.localPort);
        this.validation = null;
    }

    public String externalHostname() {
        return "localhost";
    }
}

