/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.mongodb.resource.managed;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.ExtensionContext;
import software.tnb.common.account.AccountFactory;
import software.tnb.db.mongodb.account.managed.AtlasAccount;
import software.tnb.db.mongodb.service.MongoDB;

public class AtlasMongoDB
extends MongoDB {
    private AtlasAccount account;

    public AtlasAccount account() {
        if (this.account == null) {
            this.account = (AtlasAccount)AccountFactory.create(AtlasAccount.class);
        }
        return this.account;
    }

    protected MongoClient client() {
        if (this.client == null) {
            this.client = MongoClients.create((String)String.format("mongodb+srv://%s:%s@%s/%s", this.account().username(), this.account().password(), this.account().replicaSetUrl(), this.account().database()));
        }
        return (MongoClient)this.client;
    }

    @Override
    public String replicaSetUrl() {
        return this.account().replicaSetUrl();
    }

    @Override
    public String hostname() {
        return this.client().getClusterDescription().getServerDescriptions().stream().map(s -> s.getAddress().getHost() + ":" + s.getAddress().getPort()).collect(Collectors.joining(","));
    }

    public void afterAll(ExtensionContext context) throws Exception {
    }

    public void beforeAll(ExtensionContext context) throws Exception {
    }
}

