/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.db.mongodb.resource.local;

import com.google.auto.service.AutoService;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.Deployable;
import software.tnb.db.mongodb.account.MongoDBAccount;
import software.tnb.db.mongodb.resource.local.MongoContainer;
import software.tnb.db.mongodb.service.MongoDB;

@AutoService(value={MongoDB.class})
public class LocalMongoDB
extends MongoDB
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalMongoDB.class);
    private MongoContainer container;

    public void deploy() {
        LOG.info("Starting MongoDB container");
        this.container = new MongoContainer(this.image(), this.port(), this.containerEnvironment());
        this.container.start();
        LOG.info("MongoDB container started");
    }

    public void undeploy() {
        if (this.container != null) {
            LOG.info("Stopping MongoDB container");
            this.container.stop();
        }
    }

    public void openResources() {
        LOG.debug("Creating new MongoClient instance");
        this.client = MongoClients.create((String)this.replicaSetUrl());
    }

    public void closeResources() {
        if (this.client != null) {
            LOG.debug("Closing MongoDB client");
            ((MongoClient)this.client).close();
        }
        this.validation = null;
    }

    @Override
    public String replicaSetUrl() {
        return String.format("mongodb://%s:%s@%s:%d/%s", ((MongoDBAccount)this.account()).username(), ((MongoDBAccount)this.account()).password(), this.hostname(), this.container.getPort(), ((MongoDBAccount)this.account()).database());
    }

    @Override
    public String hostname() {
        return this.container.getContainerIpAddress();
    }
}

