/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.lracoordinator.resource.local;

import com.google.auto.service.AutoService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.Deployable;
import software.tnb.lracoordinator.resource.local.LRACoordinatorContainer;
import software.tnb.lracoordinator.service.LRACoordinator;

@AutoService(value={LRACoordinator.class})
public class LocalLRACoordinator
extends LRACoordinator
implements Deployable {
    private static final Logger LOG = LoggerFactory.getLogger(LocalLRACoordinator.class);
    private LRACoordinatorContainer container;

    public void deploy() {
        LOG.info("Starting LRA Coordinator container");
        this.container = new LRACoordinatorContainer(this.image(), this.containerEnvironment());
        this.container.start();
        LOG.info("LRA Coordinator container started");
    }

    public void undeploy() {
        if (this.container != null) {
            this.container.stop();
        }
    }

    @Override
    public String hostname() {
        return "localhost";
    }

    @Override
    public int port() {
        return this.container.getPort();
    }

    @Override
    public String getUrl() {
        return String.format("http://localhost:%s", this.port());
    }

    @Override
    public String getExternalUrl() {
        return this.getUrl();
    }

    @Override
    public String getLog() {
        return this.container.getLogs();
    }
}

