/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.knative.validation;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.eventing.v1.Broker;
import io.fabric8.knative.eventing.v1.BrokerBuilder;
import io.fabric8.knative.eventing.v1.BrokerFluent;
import io.fabric8.knative.messaging.v1.Channel;
import io.fabric8.knative.messaging.v1.ChannelBuilder;
import io.fabric8.knative.messaging.v1.ChannelFluent;
import io.fabric8.knative.messaging.v1.ChannelSpecFluent;
import io.fabric8.knative.messaging.v1.InMemoryChannel;
import io.fabric8.knative.serving.v1.Route;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.dsl.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.WaitUtils;

public class KnativeValidation {
    private static final Logger LOG = LoggerFactory.getLogger(KnativeValidation.class);
    private static final String NAME_VALIDATION_REGEX = "[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*";
    private final KnativeClient client;
    private final List<HasMetadata> createdItems;

    public KnativeValidation(KnativeClient client) {
        this.client = client;
        this.createdItems = new ArrayList<HasMetadata>();
    }

    public InMemoryChannel createInMemoryChannel(String name) {
        this.validateName(name);
        LOG.debug("Creating In-Memory Channel {}", (Object)name);
        Channel channel = ((ChannelBuilder)((ChannelFluent.SpecNested)((ChannelSpecFluent.ChannelTemplateNested)((ChannelSpecFluent.ChannelTemplateNested)((ChannelBuilder)((ChannelFluent.MetadataNested)new ChannelBuilder().withNewMetadata().withName(name)).endMetadata()).withNewSpec().withNewChannelTemplate().withApiVersion("messaging.knative.dev/v1")).withKind("InMemoryChannel")).endChannelTemplate()).endSpec()).build();
        this.client.channels().createOrReplace((Object[])new Channel[]{channel});
        WaitUtils.waitFor(() -> ((Resource)this.client.inMemoryChannels().withName(name)).get() != null, (int)50, (long)5000L, (String)String.format("Waiting until the InmemoryChannel %s is available", name));
        this.createdItems.add((HasMetadata)channel);
        return (InMemoryChannel)((Resource)this.client.inMemoryChannels().withName(name)).get();
    }

    public Broker createBroker(String name) {
        this.validateName(name);
        LOG.debug("Creating Broker {}", (Object)name);
        Broker broker = ((BrokerBuilder)((BrokerFluent.MetadataNested)new BrokerBuilder().withNewMetadata().withName(name)).endMetadata()).build();
        this.client.brokers().createOrReplace((Object[])new Broker[]{broker});
        this.createdItems.add((HasMetadata)broker);
        return broker;
    }

    public void deleteCreatedResources() {
        Collections.reverse(this.createdItems);
        for (HasMetadata createdItem : this.createdItems) {
            LOG.debug("Deleting {} {}", (Object)createdItem.getKind(), (Object)createdItem.getMetadata().getName());
            OpenshiftClient.get().resource(createdItem).delete();
        }
        this.createdItems.clear();
    }

    public String getRouteUrl(String serviceName) {
        return ((Route)((Resource)this.client.routes().withName(serviceName)).get()).getStatus().getUrl();
    }

    private void validateName(String name) {
        if (!name.matches(NAME_VALIDATION_REGEX)) {
            throw new IllegalArgumentException("Name must consist of lower case alphanumeric characters, '-' or '.', and must start and end with an alphanumeric character (was: " + name + ")");
        }
    }
}

