/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.knative.service;

import com.google.auto.service.AutoService;
import cz.xtf.core.openshift.helpers.ResourceParsers;
import io.fabric8.knative.client.KnativeClient;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.ReusableOpenshiftDeployable;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.service.Service;
import software.tnb.common.utils.WaitUtils;
import software.tnb.knative.validation.KnativeValidation;

@AutoService(value={Knative.class})
public class Knative
implements Service,
ReusableOpenshiftDeployable {
    public static final String OPENSHIFT_SERVERLESS_NAMESPACE = "openshift.serverless.namespace";
    private static final String CHANNEL = "stable";
    private static final String OPERATOR_NAME = "serverless-operator";
    private static final String SOURCE = "redhat-operators";
    private static final String SUBSCRIPTION_NAME = "tnb-knative";
    private static final String SUBSCRIPTION_NAMESPACE = "openshift-marketplace";
    private static final String TARGET_NAMESPACE = System.getProperty("openshift.serverless.namespace", "openshift-serverless");
    private static final String EVENTING_NAMESPACE = "knative-eventing";
    private static final String EVENTING_CR_NAME = "knative-eventing";
    private static final String SERVING_NAMESPACE = "knative-serving";
    private static final String SERVING_CR_NAME = "knative-serving";
    private static final String CRD_GROUP = "operator.knative.dev";
    private static final String CRD_VERSION = "v1alpha1";
    private KnativeValidation validation;
    private boolean installedByDefault = true;
    private static final Logger LOG = LoggerFactory.getLogger(Knative.class);
    private static final CustomResourceDefinitionContext EVENTING_CTX = new CustomResourceDefinitionContext.Builder().withName("KnativeEventing").withGroup("operator.knative.dev").withVersion("v1alpha1").withPlural("knativeeventings").withScope("Namespaced").build();
    private static final CustomResourceDefinitionContext SERVING_CTX = new CustomResourceDefinitionContext.Builder().withName("KnativeServing").withGroup("operator.knative.dev").withVersion("v1alpha1").withPlural("knativeservings").withScope("Namespaced").build();

    public void undeploy() {
        this.validation().deleteCreatedResources();
        if (!this.installedByDefault) {
            LOG.debug("Undeploying serverless operator");
            OpenshiftClient.get().customResource(EVENTING_CTX).delete("knative-eventing");
            OpenshiftClient.get().customResource(SERVING_CTX).delete("knative-serving");
            WaitUtils.waitFor(() -> ((PodList)((NonNamespaceOperation)OpenshiftClient.get().pods().inNamespace("knative-eventing")).list()).getItems().size() == 0, (String)"Waiting until all eventing pods are terminated");
            WaitUtils.waitFor(() -> ((PodList)((NonNamespaceOperation)OpenshiftClient.get().pods().inNamespace("knative-serving")).list()).getItems().size() == 0 || ((PodList)((NonNamespaceOperation)OpenshiftClient.get().pods().inNamespace("knative-serving")).list()).getItems().stream().allMatch(p -> "succeeded".equalsIgnoreCase(p.getStatus().getPhase())), (String)"Waiting until all serving pods are terminated");
            OpenshiftClient.get().deleteSubscription(SUBSCRIPTION_NAME, TARGET_NAMESPACE);
            WaitUtils.waitFor(() -> ((PodList)((NonNamespaceOperation)OpenshiftClient.get().pods().inNamespace(TARGET_NAMESPACE)).list()).getItems().size() == 0, (String)"Waiting until all serverless operator pods are terminated");
        } else {
            LOG.debug("Not undeploying default serverless operator");
        }
    }

    public void openResources() {
    }

    public void closeResources() {
    }

    public void create() {
        LOG.debug("Creating serverless operator");
        this.installedByDefault = false;
        OpenshiftClient.get().createNamespace(TARGET_NAMESPACE);
        OpenshiftClient.get().createSubscription(CHANNEL, OPERATOR_NAME, SOURCE, SUBSCRIPTION_NAME, SUBSCRIPTION_NAMESPACE, TARGET_NAMESPACE, true);
        WaitUtils.waitFor(() -> ((Resource)OpenshiftClient.get().namespaces().withName("knative-eventing")).get() != null, (String)"Waiting until the eventing namespace is created");
        WaitUtils.waitFor(() -> ((Resource)OpenshiftClient.get().namespaces().withName("knative-serving")).get() != null, (String)"Waiting until the serving namespace is created");
        try {
            OpenshiftClient.get().customResource(EVENTING_CTX).createOrReplace("knative-eventing", this.createCr("KnativeEventing", "knative-eventing", "knative-eventing"));
            OpenshiftClient.get().customResource(SERVING_CTX).createOrReplace("knative-serving", this.createCr("KnativeServing", "knative-serving", "knative-serving"));
        }
        catch (IOException e) {
            Assertions.fail((String)"Unable to create custom resources: ", (Throwable)e);
        }
    }

    public boolean isReady() {
        return ((DeploymentList)((NonNamespaceOperation)OpenshiftClient.get().apps().deployments().inNamespace(TARGET_NAMESPACE)).list()).getItems().stream().allMatch(d -> d.getSpec().getReplicas() == 0 || d.getSpec().getReplicas().equals(d.getStatus().getAvailableReplicas())) && ((DeploymentList)((NonNamespaceOperation)OpenshiftClient.get().apps().deployments().inNamespace("knative-eventing")).list()).getItems().stream().allMatch(d -> d.getSpec().getReplicas() == 0 || d.getSpec().getReplicas().equals(d.getStatus().getAvailableReplicas())) && ((DeploymentList)((NonNamespaceOperation)OpenshiftClient.get().apps().deployments().inNamespace("knative-serving")).list()).getItems().stream().allMatch(d -> d.getSpec().getReplicas() == 0 || d.getSpec().getReplicas().equals(d.getStatus().getAvailableReplicas()));
    }

    public boolean isDeployed() {
        List pods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)OpenshiftClient.get().pods().inNamespace(TARGET_NAMESPACE)).withLabel("name", "knative-operator")).list()).getItems();
        return pods.size() == 1 && ResourceParsers.isPodReady((Pod)((Pod)pods.get(0))) && ((List)OpenshiftClient.get().customResource(EVENTING_CTX).list("knative-eventing").get("items")).size() == 1 && ((List)OpenshiftClient.get().customResource(SERVING_CTX).list("knative-serving").get("items")).size() == 1;
    }

    protected KnativeClient client() {
        if (OpenshiftClient.get().isAdaptable(KnativeClient.class).booleanValue()) {
            return (KnativeClient)OpenshiftClient.get().adapt(KnativeClient.class);
        }
        throw new IllegalArgumentException("Unable to adapt OpenshiftClient to KnativeClient");
    }

    public KnativeValidation validation() {
        if (this.validation == null) {
            this.validation = new KnativeValidation(this.client());
        }
        return this.validation;
    }

    private Map<String, Object> createCr(String kind, String name, String namespace) {
        HashMap<String, Object> cr = new HashMap<String, Object>();
        cr.put("apiVersion", "operator.knative.dev/v1alpha1");
        cr.put("kind", kind);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("name", name);
        metadata.put("namespace", namespace);
        cr.put("metadata", metadata);
        return cr;
    }

    public void cleanup() {
        if (this.validation != null) {
            this.validation.deleteCreatedResources();
        }
    }
}

