/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.knative.resource;

import com.google.auto.service.AutoService;
import cz.xtf.core.openshift.helpers.ResourceParsers;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeException;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.deployment.OpenshiftDeployable;
import software.tnb.common.deployment.WithOperatorHub;
import software.tnb.common.openshift.OpenshiftClient;
import software.tnb.common.utils.WaitUtils;
import software.tnb.knative.service.Knative;
import software.tnb.knative.validation.KnativeValidation;

@AutoService(value={Knative.class})
public class OpenshiftKnative
extends Knative
implements OpenshiftDeployable,
WithOperatorHub {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftKnative.class);
    private static final String CRD_GROUP = "operator.knative.dev";
    private static final String CRD_VERSION = "v1beta1";
    private static final CustomResourceDefinitionContext EVENTING_CTX = new CustomResourceDefinitionContext.Builder().withName("KnativeEventing").withGroup("operator.knative.dev").withVersion("v1beta1").withPlural("knativeeventings").withScope("Namespaced").build();
    private static final CustomResourceDefinitionContext SERVING_CTX = new CustomResourceDefinitionContext.Builder().withName("KnativeServing").withGroup("operator.knative.dev").withVersion("v1beta1").withPlural("knativeservings").withScope("Namespaced").build();
    private static final String EVENTING_NAMESPACE = "knative-eventing";
    private static final String EVENTING_CR_NAME = "knative-eventing";
    private static final String SERVING_NAMESPACE = "knative-serving";
    private static final String SERVING_CR_NAME = "knative-serving";

    public void undeploy() {
    }

    public void openResources() {
    }

    public void closeResources() {
        if (this.validation != null) {
            ((KnativeValidation)this.validation).deleteCreatedResources();
        }
    }

    public void create() {
        LOG.debug("Creating serverless operator");
        OpenshiftClient.get().createNamespace(this.targetNamespace());
        this.createSubscription();
        WaitUtils.waitFor(() -> ((Resource)OpenshiftClient.get().namespaces().withName("knative-eventing")).get() != null, (String)"Waiting until the eventing namespace is created");
        WaitUtils.waitFor(() -> ((Resource)OpenshiftClient.get().namespaces().withName("knative-serving")).get() != null, (String)"Waiting until the serving namespace is created");
        try {
            RetryPolicy retryPolicy = ((RetryPolicyBuilder)RetryPolicy.builder().handle(KubernetesClientTimeoutException.class)).withDelay(Duration.ofSeconds(5L)).withMaxRetries(3).build();
            Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> OpenshiftClient.get().customResource(EVENTING_CTX).inNamespace("knative-eventing").createOrReplace(this.createCr("KnativeEventing", "knative-eventing", "knative-eventing")));
            Failsafe.with((Policy)retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> OpenshiftClient.get().customResource(SERVING_CTX).inNamespace("knative-serving").createOrReplace(this.createCr("KnativeServing", "knative-serving", "knative-serving")));
        }
        catch (FailsafeException e) {
            Assertions.fail((String)"Unable to create custom resources: ", (Throwable)e.getCause());
        }
    }

    public boolean isReady() {
        return ((DeploymentList)((NonNamespaceOperation)OpenshiftClient.get().apps().deployments().inNamespace(this.targetNamespace())).list()).getItems().stream().allMatch(d -> d.getSpec().getReplicas() == 0 || d.getSpec().getReplicas().equals(d.getStatus().getAvailableReplicas())) && ((DeploymentList)((NonNamespaceOperation)OpenshiftClient.get().apps().deployments().inNamespace("knative-eventing")).list()).getItems().stream().allMatch(d -> d.getSpec().getReplicas() == 0 || d.getSpec().getReplicas().equals(d.getStatus().getAvailableReplicas())) && ((DeploymentList)((NonNamespaceOperation)OpenshiftClient.get().apps().deployments().inNamespace("knative-serving")).list()).getItems().stream().allMatch(d -> d.getSpec().getReplicas() == 0 || d.getSpec().getReplicas().equals(d.getStatus().getAvailableReplicas()));
    }

    public boolean isDeployed() {
        List pods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)OpenshiftClient.get().pods().inNamespace(this.targetNamespace())).withLabel("name", "knative-operator")).list()).getItems();
        return pods.size() == 1 && ResourceParsers.isPodReady((Pod)((Pod)pods.get(0))) && ((List)OpenshiftClient.get().customResource(EVENTING_CTX).list("knative-eventing").get("items")).size() == 1 && ((List)OpenshiftClient.get().customResource(SERVING_CTX).list("knative-serving").get("items")).size() == 1;
    }

    public Predicate<Pod> podSelector() {
        return null;
    }

    public void restart() {
    }

    private Map<String, Object> createCr(String kind, String name, String namespace) {
        HashMap<String, Object> cr = new HashMap<String, Object>();
        cr.put("apiVersion", "operator.knative.dev/v1beta1");
        cr.put("kind", kind);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("name", name);
        metadata.put("namespace", namespace);
        cr.put("metadata", metadata);
        return cr;
    }

    public String targetNamespace() {
        return "openshift-serverless";
    }

    public String operatorName() {
        return "serverless-operator";
    }

    public boolean clusterWide() {
        return true;
    }
}

