/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.kafka.resource.local;

import org.apache.commons.lang3.RandomStringUtils;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import software.tnb.common.utils.NetworkUtils;

public class ZookeeperContainer
extends GenericContainer<ZookeeperContainer> {
    public static final String CONTAINER_NAME = "zookeeper" + RandomStringUtils.randomAlphabetic((int)5);
    public static final int ZOOKEEPER_PORT = NetworkUtils.getFreePort();

    public ZookeeperContainer(String image, Network network) {
        super(image);
        this.withNetwork(network);
        this.withCreateContainerCmdModifier(cmd -> {
            cmd.withHostName(CONTAINER_NAME);
            cmd.withName(CONTAINER_NAME);
        });
        this.addFixedExposedPort(ZOOKEEPER_PORT, ZOOKEEPER_PORT);
        this.withEnv("LOG_DIR", "/tmp/log");
        this.withCommand(new String[]{"sh", "-c", "sed 's/2181/" + ZOOKEEPER_PORT + "/' config/zookeeper.properties > /tmp/zookeeper.properties && bin/zookeeper-server-start.sh /tmp/zookeeper.properties"});
        this.waitingFor((WaitStrategy)Wait.forListeningPort());
    }
}

