/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.kafka.resource.local;

import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;
import software.tnb.common.utils.NetworkUtils;
import software.tnb.kafka.resource.local.ZookeeperContainer;

public class StrimziContainer
extends GenericContainer<StrimziContainer> {
    private static final String CONTAINER_NAME = "kafka" + RandomStringUtils.randomAlphabetic((int)5);
    private static final int KAFKA_PORT = NetworkUtils.getFreePort();

    public StrimziContainer(String image, Network network) {
        super(image);
        this.withNetwork(network);
        this.withCreateContainerCmdModifier(cmd -> {
            cmd.withHostName(CONTAINER_NAME);
            cmd.withName(CONTAINER_NAME);
        });
        String listenerAddress = "localhost";
        String dockerHost = (String)TestcontainersConfiguration.getInstance().getEnvironment().get("DOCKER_HOST");
        if (dockerHost != null) {
            listenerAddress = StringUtils.substringBetween((String)dockerHost, (String)"tcp://", (String)":");
        }
        this.addFixedExposedPort(KAFKA_PORT, KAFKA_PORT);
        this.withEnv("LOG_DIR", "/tmp/log");
        this.withCommand(new String[]{"sh", "-c", String.format("bin/kafka-server-start.sh config/server.properties --override zookeeper.connect=%s:%d --override advertised.listeners=PLAINTEXT://%s:%d --override listeners=PLAINTEXT://:%d", ZookeeperContainer.CONTAINER_NAME, ZookeeperContainer.ZOOKEEPER_PORT, listenerAddress, KAFKA_PORT, KAFKA_PORT)});
        this.waitingFor((WaitStrategy)Wait.forListeningPort());
    }

    public int getKafkaPort() {
        return this.getMappedPort(KAFKA_PORT);
    }
}

