/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.kafka.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import software.tnb.common.account.AccountFactory;
import software.tnb.common.service.Service;
import software.tnb.kafka.account.KafkaAccount;
import software.tnb.kafka.validation.KafkaValidation;

public abstract class Kafka
implements Service {
    protected Map<Class<?>, KafkaValidation> validations;
    protected Properties props = this.defaultClientProperties();
    private KafkaAccount account;

    public abstract String bootstrapServers();

    public abstract String bootstrapSSLServers();

    public abstract void createTopic(String var1, int var2, int var3);

    public KafkaAccount account() {
        if (this.account == null) {
            this.account = (KafkaAccount)AccountFactory.create(KafkaAccount.class);
        }
        return this.account;
    }

    public <T> KafkaValidation<T> validation(Class<T> clazz) {
        if (!this.validations.containsKey(clazz)) {
            this.validations.put(clazz, this.createValidation(clazz));
        }
        return this.validations.get(clazz);
    }

    public KafkaValidation<String> validation() {
        return this.validation(String.class);
    }

    private <T> KafkaValidation<T> createValidation(Class<T> clazz) {
        if (clazz.isInstance(new byte[0])) {
            this.props.setProperty("value.serializer", ByteArraySerializer.class.getName());
            this.props.setProperty("value.deserializer", ByteArrayDeserializer.class.getName());
        } else if (clazz.isInstance("")) {
            this.props.setProperty("value.serializer", StringSerializer.class.getName());
            this.props.setProperty("value.deserializer", StringDeserializer.class.getName());
        } else {
            throw new IllegalArgumentException("Unsupported class type passed to validation() method: " + clazz.getName());
        }
        return new KafkaValidation(new KafkaProducer(this.props), new KafkaConsumer(this.props));
    }

    protected Properties defaultClientProperties() {
        Properties properties = new Properties();
        properties.setProperty("key.serializer", StringSerializer.class.getName());
        properties.setProperty("key.deserializer", StringDeserializer.class.getName());
        properties.setProperty("group.id", UUID.randomUUID().toString());
        properties.setProperty("auto.offset.reset", "earliest");
        return properties;
    }

    public void openResources() {
        this.validations = new HashMap();
    }

    public void closeResources() {
        this.validations.values().forEach(validation -> {
            validation.closeProducer();
            validation.closeConsumer();
        });
        this.validations = null;
    }
}

