/*
 * Decompiled with CFR 0.152.
 */
package software.tnb.kafka.resource.openshift;

import com.google.auto.service.AutoService;
import cz.xtf.core.openshift.OpenShift;
import cz.xtf.core.openshift.OpenShiftWaiters;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretBuilder;
import io.fabric8.kubernetes.api.model.SecretFluent;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import io.strimzi.api.kafka.KafkaList;
import io.strimzi.api.kafka.KafkaTopicList;
import io.strimzi.api.kafka.model.Kafka;
import io.strimzi.api.kafka.model.KafkaBuilder;
import io.strimzi.api.kafka.model.KafkaClusterSpecFluent;
import io.strimzi.api.kafka.model.KafkaFluent;
import io.strimzi.api.kafka.model.KafkaSpecFluent;
import io.strimzi.api.kafka.model.KafkaTopic;
import io.strimzi.api.kafka.model.KafkaTopicBuilder;
import io.strimzi.api.kafka.model.KafkaTopicFluent;
import io.strimzi.api.kafka.model.listener.arraylistener.KafkaListenerType;
import io.strimzi.api.kafka.model.status.Condition;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import org.apache.kafka.clients.admin.AdminClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.tnb.common.config.TestConfiguration;
import software.tnb.common.deployment.ReusableOpenshiftDeployable;
import software.tnb.common.deployment.WithName;
import software.tnb.common.deployment.WithOperatorHub;
import software.tnb.common.openshift.OpenshiftClient;

@AutoService(value={software.tnb.kafka.service.Kafka.class})
public class OpenshiftKafka
extends software.tnb.kafka.service.Kafka
implements ReusableOpenshiftDeployable,
WithName,
WithOperatorHub {
    private static final Logger LOG = LoggerFactory.getLogger(OpenshiftKafka.class);
    private static final String CRD_GROUP = "kafka.strimzi.io";
    private static final String CRD_VERSION = "v1beta2";
    private static final CustomResourceDefinitionContext KAFKA_CONTEXT = new CustomResourceDefinitionContext.Builder().withName("Kafka").withGroup("kafka.strimzi.io").withVersion("v1beta2").withPlural("kafkas").withScope("Namespaced").build();
    private static final MixedOperation<Kafka, KafkaList, Resource<Kafka>> KAFKA_CRD_CLIENT = OpenshiftClient.get().customResources((ResourceDefinitionContext)KAFKA_CONTEXT, Kafka.class, KafkaList.class);
    private static final CustomResourceDefinitionContext KAFKA_TOPIC_CONTEXT = new CustomResourceDefinitionContext.Builder().withName("KafkaTopic").withGroup("kafka.strimzi.io").withVersion("v1beta2").withPlural("kafkatopics").withScope("Namespaced").build();
    private static final MixedOperation<KafkaTopic, KafkaTopicList, Resource<KafkaTopic>> KAFKA_TOPIC_CRD_CLIENT = OpenshiftClient.get().customResources((ResourceDefinitionContext)KAFKA_TOPIC_CONTEXT, KafkaTopic.class, KafkaTopicList.class);

    public long waitTime() {
        return 600000L;
    }

    public Predicate<Pod> podSelector() {
        return p -> OpenshiftClient.get().hasLabels(p, Map.of("strimzi.io/name", this.name() + "-kafka"));
    }

    public void undeploy() {
        if (!TestConfiguration.skipTearDownOpenshiftAMQStreams()) {
            ((EditReplacePatchDeletable)((Resource)KAFKA_CRD_CLIENT.withName(this.name())).withPropagationPolicy(DeletionPropagation.BACKGROUND)).delete();
            OpenShiftWaiters.get((OpenShift)OpenshiftClient.get(), () -> false).areNoPodsPresent("strimzi.io/cluster", this.name()).timeout(120000L).waitFor();
            this.deleteSubscription(() -> OpenshiftClient.get().getLabeledPods("strimzi.io/kind", "cluster-operator").isEmpty());
        }
    }

    @Override
    public void openResources() {
        this.createBasicUser();
        this.extractCertificate();
        this.connectionProperties();
        super.openResources();
    }

    public void create() {
        this.createSubscription();
        this.deployKafkaCR();
    }

    public List<EnvVar> getOperatorEnvVariables() {
        return List.of(new EnvVar("FIPS_MODE", "disabled", null));
    }

    public boolean isReady() {
        try {
            return ((Kafka)((Resource)KAFKA_CRD_CLIENT.withName(this.name())).get()).getStatus().getConditions().stream().filter(c -> "Ready".equals(c.getType())).map(Condition::getStatus).map(Boolean::parseBoolean).findFirst().orElse(false);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public boolean isDeployed() {
        return OpenshiftClient.get().getLabeledPods("name", "amq-streams-cluster-operator").size() != 0 && ((Resource)KAFKA_CRD_CLIENT.withName(this.name())).get() != null;
    }

    public String name() {
        return "my-kafka-cluster";
    }

    private void deployKafkaCR() {
        Kafka kafka = ((KafkaBuilder)((KafkaFluent.SpecNested)((KafkaSpecFluent.EntityOperatorNested)((KafkaSpecFluent.EntityOperatorNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.ZookeeperNested)((KafkaSpecFluent.ZookeeperNested)((KafkaFluent.SpecNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaSpecFluent.KafkaNested)((KafkaClusterSpecFluent.ListenersNested)((KafkaClusterSpecFluent.ListenersNested)((KafkaClusterSpecFluent.ListenersNested)((KafkaClusterSpecFluent.ListenersNested)((KafkaSpecFluent.KafkaNested)((KafkaClusterSpecFluent.ListenersNested)((KafkaClusterSpecFluent.ListenersNested)((KafkaClusterSpecFluent.ListenersNested)((KafkaClusterSpecFluent.ListenersNested)((KafkaSpecFluent.KafkaNested)((KafkaBuilder)((CustomResourceFluent.MetadataNested)new KafkaBuilder().withNewMetadata().withName(this.name())).endMetadata()).withNewSpec().withNewKafka().withReplicas(1)).addNewListener().withName("plain")).withPort(9092)).withTls(false)).withType(KafkaListenerType.INTERNAL)).endListener()).addNewListener().withName("route")).withPort(9093)).withTls(true)).withType(KafkaListenerType.ROUTE)).endListener()).withNewEphemeralStorage().endEphemeralStorage()).addToConfig("offsets.topic.replication.factor", (Object)1)).addToConfig("transaction.state.log.replication.factor", (Object)1)).addToConfig("transaction.state.log.min.isr", (Object)1)).endKafka()).withNewZookeeper().withReplicas(1)).withNewEphemeralStorage().endEphemeralStorage()).endZookeeper()).withNewEntityOperator().withNewTopicOperator().endTopicOperator()).withNewUserOperator().endUserOperator()).endEntityOperator()).endSpec()).build();
        KAFKA_CRD_CLIENT.createOrReplace((Object[])new Kafka[]{kafka});
    }

    @Override
    public String bootstrapServers() {
        return this.findBootstrapServers("plain");
    }

    @Override
    public String bootstrapSSLServers() {
        return this.findBootstrapServers("route");
    }

    private String findBootstrapServers(String listnerType) {
        return ((Kafka)((Resource)KAFKA_CRD_CLIENT.withName(this.name())).get()).getStatus().getListeners().stream().filter(l -> listnerType.equals(l.getType())).findFirst().get().getBootstrapServers();
    }

    @Override
    public void createTopic(String name, int partitions, int replicas) {
        KafkaTopic kafkaTopic = ((KafkaTopicBuilder)((KafkaTopicFluent.SpecNested)((KafkaTopicFluent.SpecNested)((KafkaTopicBuilder)((CustomResourceFluent.MetadataNested)((CustomResourceFluent.MetadataNested)new KafkaTopicBuilder().withNewMetadata().withName(name)).addToLabels("strimzi.io/cluster", this.name())).endMetadata()).withNewSpec().withPartitions(Integer.valueOf(partitions))).withReplicas(Integer.valueOf(replicas))).endSpec()).build();
        KAFKA_TOPIC_CRD_CLIENT.createOrReplace((Object[])new KafkaTopic[]{kafkaTopic});
    }

    private void createBasicUser() {
        String password = Base64.getEncoder().encodeToString(this.account().basicPassword().getBytes());
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("strimzi.io/kind", "KafkaUser");
        labels.put("strimzi.io/cluster", this.name());
        SecretBuilder sb = (SecretBuilder)((SecretBuilder)((SecretBuilder)((SecretFluent.MetadataNested)((SecretFluent.MetadataNested)((SecretBuilder)new SecretBuilder().withApiVersion("v1")).editOrNewMetadata().withName(this.account().basicUser())).withLabels(labels)).endMetadata()).withType("Opaque")).withData(Collections.singletonMap("password", password));
        OpenshiftClient.get().secrets().createOrReplace((Object[])new Secret[]{sb.build()});
    }

    public void cleanup() {
        LOG.debug("Cleaning kafka instance");
        AdminClient adminClient = AdminClient.create((Properties)this.props);
        try {
            adminClient.deleteTopics((Collection)adminClient.listTopics().names().get());
            adminClient.close();
        }
        catch (Exception e) {
            LOG.warn("Unable to clean kafka instance", (Throwable)e);
        }
    }

    public void extractCertificate() {
        LOG.debug("Extracting kafka certificate");
        String cert = new String(Base64.getDecoder().decode((String)((Secret)((Resource)OpenshiftClient.get().secrets().withName(this.name() + "-cluster-ca-cert")).get()).getData().get("ca.crt")));
        String password = new String(Base64.getDecoder().decode((String)((Secret)((Resource)OpenshiftClient.get().secrets().withName(this.name() + "-cluster-ca-cert")).get()).getData().get("ca.password")));
        this.account().setTrustStorePassword(password);
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(null, password.toCharArray());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            try (ByteArrayInputStream is = new ByteArrayInputStream(cert.getBytes());){
                ks.setCertificateEntry("ca.crt", cf.generateCertificate(is));
            }
            FileOutputStream fos = new FileOutputStream(this.account().trustStore());
            ks.store(fos, password.toCharArray());
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to extract kafka certificate", e);
        }
    }

    private void connectionProperties() {
        this.props.setProperty("bootstrap.servers", this.bootstrapSSLServers());
        this.props.setProperty("security.protocol", "SSL");
        this.props.setProperty("ssl.truststore.password", this.account().trustStorePassword());
        this.props.setProperty("ssl.truststore.location", new File(this.account().trustStore()).getAbsolutePath());
        this.props.setProperty("ssl.truststore.type", "PKCS12");
    }

    public String operatorName() {
        return "amq-streams";
    }
}

